/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.filePreview;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.filePreview.FilePreviewConfigurator;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.out.Logger;

enum FileType {
    Folder,
    Text,
    HTML,
    PDF,
    OOConvertable,
    GraphicsNative,
    GraphicsImageIO,
    GraphicsJAIConvertableImageRead,
    GraphicsJIMIConvertable,
    GraphicsImageMagickConvertable,
    Unknown;

    static FilePreviewConfigurator filePreviewConfigurator;

    static FileType check(NodeAbstract node) {
        if (node.isFolder()) {
            return Folder;
        }
        FileType fileType = Unknown;
        String formatKey = node.getFormatKey();
        if (formatKey != null && (fileType = FileType.getFileType(formatKey)) != null && !Unknown.equals((Object)fileType)) {
            return fileType;
        }
        String mimeType = node.getMimeType();
        if (mimeType != null && (fileType = FileType.getFileType(mimeType)) != null && !Unknown.equals((Object)fileType)) {
            return fileType;
        }
        String extension = FileUtil.asFileNameExtension((String)node.getLabel());
        if (extension != null && (fileType = FileType.getFileType(extension = extension.toLowerCase())) != null && !Unknown.equals((Object)fileType)) {
            return fileType;
        }
        return Unknown;
    }

    static FileType getFileType(String formatKeyOrMimeTypeOrExtension) {
        FileType fileType = Unknown;
        String propertyValue = filePreviewConfigurator.getPropertyValue(formatKeyOrMimeTypeOrExtension);
        if (propertyValue != null) {
            try {
                fileType = FileType.valueOf(propertyValue);
            }
            catch (Exception e) {
                Logger.warn((Object)("getFileType - cannot find FileType for " + formatKeyOrMimeTypeOrExtension));
            }
        }
        return fileType;
    }

    static {
        if (filePreviewConfigurator == null) {
            filePreviewConfigurator = new FilePreviewConfigurator();
        }
    }
}

