/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.Searcher;
import net.byteseek.utils.ArgUtils;

public class BackwardSearchIterator<T>
implements Iterator<List<SearchResult<T>>> {
    private final byte[] bytes;
    private final WindowReader reader;
    private final long toPosition;
    private final Searcher<T> searcher;
    private long searchPosition;
    private boolean searchedForNext = false;
    private List<SearchResult<T>> searchResults = Collections.emptyList();

    public BackwardSearchIterator(Searcher<T> searcher, WindowReader reader) throws IOException {
        this(searcher, reader.length() - 1L, 0L, reader);
    }

    public BackwardSearchIterator(Searcher<T> searcher, WindowReader reader, long fromPosition) {
        this(searcher, fromPosition, 0L, reader);
    }

    public BackwardSearchIterator(Searcher<T> searcher, long fromPosition, long toPosition, WindowReader reader) {
        ArgUtils.checkNullObject(searcher, "searcher");
        ArgUtils.checkNullObject(reader, "reader");
        this.searcher = searcher;
        this.reader = reader;
        this.toPosition = toPosition;
        this.bytes = null;
        this.searchPosition = fromPosition;
    }

    public BackwardSearchIterator(Searcher<T> searcher, byte[] bytes) {
        this(searcher, bytes.length - 1, 0, bytes);
    }

    public BackwardSearchIterator(Searcher<T> searcher, byte[] bytes, int fromPosition) {
        this(searcher, fromPosition, 0, bytes);
    }

    public BackwardSearchIterator(Searcher<T> searcher, int fromPosition, int toPosition, byte[] bytes) {
        ArgUtils.checkNullObject(searcher, "searcher");
        ArgUtils.checkNullObject(bytes, "bytes");
        this.searcher = searcher;
        this.bytes = bytes;
        this.toPosition = toPosition;
        this.reader = null;
        this.searchPosition = fromPosition;
    }

    @Override
    public boolean hasNext() {
        if (!this.searchedForNext) {
            try {
                this.searchResults = this.getNextSearchResults();
                this.searchedForNext = true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return !this.searchResults.isEmpty();
    }

    @Override
    public List<SearchResult<T>> next() {
        if (this.hasNext()) {
            this.searchPosition = this.getNextSearchPosition();
            this.searchedForNext = false;
            return this.searchResults;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove search results.");
    }

    public long getSearchPosition() {
        return this.searchPosition;
    }

    public void setSearchPosition(long searchPosition) {
        this.searchPosition = searchPosition;
        this.searchedForNext = false;
    }

    private List<SearchResult<T>> getNextSearchResults() throws IOException {
        List<SearchResult<T>> nextMatchingPosition = Collections.emptyList();
        if (this.reader != null) {
            nextMatchingPosition = this.searcher.searchBackwards(this.reader, this.searchPosition, this.toPosition);
        } else if (this.bytes != null) {
            nextMatchingPosition = this.searcher.searchBackwards(this.bytes, (int)this.searchPosition, (int)this.toPosition);
        }
        return nextMatchingPosition;
    }

    private long getNextSearchPosition() {
        long furthestPosition = Long.MAX_VALUE;
        for (SearchResult<T> result : this.searchResults) {
            long resultPosition = result.getMatchPosition();
            if (resultPosition >= furthestPosition) continue;
            furthestPosition = resultPosition;
        }
        return furthestPosition - 1L;
    }
}

