/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.converter.exceptions.PDFToolsAppendDocException;
import ch.docuteam.converter.exceptions.PDFToolsCantCloseJobException;
import ch.docuteam.converter.exceptions.PDFToolsCantCreateOutputException;
import ch.docuteam.converter.exceptions.PDFToolsConverterBadVMArgumentException;
import ch.docuteam.tools.out.Logger;
import com.pdftools.converter.Converter;
import com.pdftools.converter.Job;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.SocketException;

@Deprecated(since="7.0", forRemoval=true)
public class PDFToolsConverter {
    private static Converter ConverterInstance;
    private static Job JobInstance;

    public static void main(String ... args) throws SocketException, PDFToolsConverterBadVMArgumentException, PDFToolsCantCreateOutputException, PDFToolsAppendDocException, PDFToolsCantCloseJobException {
        if (args.length < 2 && args.length > 4) {
            Logger.error((Object)"Wrong number of arguments.");
            Logger.error((Object)"Usage: PDFToolsConverter [path/to/]sourceFile [path/to/]destinationFile [document options [job options]]");
            return;
        }
        if (args.length == 2) {
            PDFToolsConverter.convert2PDF(args[0], args[1]);
        } else if (args.length == 3) {
            PDFToolsConverter.convert2PDF(args[0], args[1], args[2]);
        } else if (args.length == 4) {
            PDFToolsConverter.convert2PDF(args[0], args[1], args[2], args[3]);
        }
    }

    public static void initialize() throws SocketException, PDFToolsConverterBadVMArgumentException {
        PDFToolsConverter.initialize(null);
    }

    public static void initialize(String url) throws SocketException, PDFToolsConverterBadVMArgumentException {
        PDFToolsConverter.checkRequiredVMArgument();
        Logger.debug((Object)("CreateConverter with url: " + url));
        ConverterInstance = Converter.createConverter((String)url);
        JobInstance = ConverterInstance.createJob();
    }

    public static void disconnect() {
        if (JobInstance != null) {
            JobInstance.destroyObject();
        }
        if (ConverterInstance != null) {
            ConverterInstance.destroyObject();
        }
    }

    public static void convert2PDF(String sourceFilePath, String destinationFilePath) throws SocketException, PDFToolsConverterBadVMArgumentException, PDFToolsCantCreateOutputException, PDFToolsAppendDocException, PDFToolsCantCloseJobException {
        PDFToolsConverter.convert2PDF(sourceFilePath, destinationFilePath, "");
    }

    public static void convert2PDF(String sourceFilePath, String destinationFilePath, String documentOptions) throws SocketException, PDFToolsConverterBadVMArgumentException, PDFToolsCantCreateOutputException, PDFToolsAppendDocException, PDFToolsCantCloseJobException {
        PDFToolsConverter.convert2PDF(sourceFilePath, destinationFilePath, documentOptions, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert2PDF(String sourceFilePath, String destinationFilePath, String documentOptions, String jobOptions) throws SocketException, PDFToolsConverterBadVMArgumentException, PDFToolsCantCreateOutputException, PDFToolsAppendDocException, PDFToolsCantCloseJobException {
        PDFToolsConverter.initializeIfNecessary();
        if (JobInstance == null) {
            Logger.error((Object)"PDF-Tools Converter can not be initialized");
            return;
        }
        Logger.info((Object)("Converting: '" + sourceFilePath + "' to: '" + destinationFilePath + "'"));
        boolean ok = false;
        try {
            ok = JobInstance.createOutput(destinationFilePath);
            if (!ok) {
                String message = "Returned error Code: " + PDFToolsConverter.JobInstance.getLastError().Code + ", error text: " + PDFToolsConverter.JobInstance.getLastError().Text + ", when attempted to create file: " + destinationFilePath;
                throw new PDFToolsCantCreateOutputException(message);
            }
            JobInstance.setOptions(jobOptions);
            ok = JobInstance.appendDoc(sourceFilePath, documentOptions);
            if (!ok) {
                String message = "Append Doc for file: " + sourceFilePath + " failed with code: " + PDFToolsConverter.JobInstance.getLastError().Code + " and with text: " + PDFToolsConverter.JobInstance.getLastError().Text;
                throw new PDFToolsAppendDocException(message);
            }
        }
        finally {
            boolean okClose = JobInstance.close();
            if (!okClose && ok) {
                String message = "Can't close pdf tools job instance, code: " + PDFToolsConverter.JobInstance.getLastError().Code + " text: " + PDFToolsConverter.JobInstance.getLastError().Text;
                throw new PDFToolsCantCloseJobException(message);
            }
        }
    }

    private static void initializeIfNecessary() throws SocketException, PDFToolsConverterBadVMArgumentException {
        if (JobInstance == null) {
            PDFToolsConverter.initialize();
        }
    }

    private static void checkRequiredVMArgument() throws PDFToolsConverterBadVMArgumentException {
        String javaLibraryPath = null;
        for (String vmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!vmArg.startsWith("-Djava.library.path")) continue;
            javaLibraryPath = vmArg.substring(vmArg.lastIndexOf("=") + 1).trim();
            break;
        }
        if (javaLibraryPath == null) {
            javaLibraryPath = System.getProperty("java.library.path");
        }
        if (javaLibraryPath == null) {
            throw new PDFToolsConverterBadVMArgumentException("The Java VM Argument '-Djava.library.path' is not defined. It has to point to the folder containing the file 'O2PProxyAPI.dll'");
        }
        for (String path : javaLibraryPath.split(";")) {
            if (!new File(path + File.separator + "O2PProxyAPI.dll").exists()) continue;
            return;
        }
        throw new PDFToolsConverterBadVMArgumentException("The Java VM Argument '-Djava.library.path' doesn't point to the folder containing the file 'O2PProxyAPI.dll': '" + javaLibraryPath + "'");
    }
}

