/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;

public class IccpChunk
extends PNGChunk {
    public IccpChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badChunk = "Bad iCCP chunk";
        this.processChunkCommon(info);
        ErrorMessage msg = null;
        if (this._module.isPlteSeen()) {
            msg = new ErrorMessage("iCCP chunk is not allowed after PLTE chunk");
        } else if (this._module.isIdatSeen()) {
            msg = new ErrorMessage("iCCP chunk is not allowed after IDAT chunk");
        } else if (this._module.isChunkSeen(1934772034)) {
            msg = new ErrorMessage("iCCP and sRGB chunks are not allowed in the same file");
        }
        if (msg != null) {
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException("Bad iCCP chunk");
        }
        int state = 0;
        int compression = -1;
        StringBuilder nameSB = new StringBuilder();
        int i = 0;
        while ((long)i < this.length) {
            int c = this.readUnsignedByte();
            switch (state) {
                case 0: {
                    if (c == 0) {
                        state = 1;
                        break;
                    }
                    nameSB.append((char)c);
                    break;
                }
                case 1: {
                    compression = c;
                    state = 2;
                    break;
                }
            }
            ++i;
        }
        if (state != 2) {
            msg = new ErrorMessage("Malformed iCCP chunk");
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException("Bad iCCP chunk");
        }
        Property profile = new Property("ICC Profile name", PropertyType.STRING, nameSB.toString());
        String cmprsType = compression == 0 ? "Deflate" : Integer.toString(compression);
        Property profileCompression = new Property("ICC Profile compression", PropertyType.STRING, cmprsType);
        this._propList.add(profile);
        this._propList.add(profileCompression);
    }
}

