/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiFactoryManager;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiProExtension;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiWriter;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageImporter;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.QueuedImageProducerProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Jimi {
    public static final int ASYNCHRONOUS = 1;
    public static final int SYNCHRONOUS = 2;
    public static final int IN_MEMORY = 4;
    public static final int VIRTUAL_MEMORY = 8;
    public static final int ONE_SHOT = 16;
    protected static int defaultFlags;
    protected static JimiImageFactory memoryFactory;
    protected static JimiImageFactory vmemFactory;
    protected static JimiImageFactory oneshotFactory;
    static boolean limited;
    static boolean crippled;
    static boolean demoversion;
    static /* synthetic */ Class class$com$sun$jimi$core$Jimi;

    static {
        if (System.getSecurityManager() == null) {
            System.runFinalizersOnExit((boolean)true);
        }
        defaultFlags = 5;
        limited = false;
        crippled = false;
        demoversion = false;
        JimiControl.addExtension(new JimiProExtension());
        memoryFactory = JimiFactoryManager.getMemoryFactory();
        oneshotFactory = JimiFactoryManager.getOneshotFactory();
    }

    private Jimi() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static JimiReader createJimiReader(InputStream inputStream) throws JimiException {
        return Jimi.createJimiReader(inputStream, defaultFlags);
    }

    public static JimiReader createJimiReader(InputStream inputStream, int n) throws JimiException {
        return new JimiReader(Jimi.getFactory(n), inputStream);
    }

    public static JimiReader createJimiReader(String string) throws JimiException {
        return Jimi.createJimiReader(string, defaultFlags);
    }

    public static JimiReader createJimiReader(String string, int n) throws JimiException {
        return new JimiReader(Jimi.getFactory(n), string);
    }

    public static JimiReader createJimiReader(URL uRL) throws JimiException {
        return Jimi.createJimiReader(uRL, defaultFlags);
    }

    public static JimiReader createJimiReader(URL uRL, int n) throws JimiException {
        return new JimiReader(Jimi.getFactory(n), uRL);
    }

    public static JimiWriter createJimiWriter(String string) throws JimiException {
        return new JimiWriter(string);
    }

    public static JimiWriter createJimiWriter(String string, OutputStream outputStream) throws JimiException {
        return new JimiWriter(outputStream, string);
    }

    public static JimiRasterImage createRasterImage(ImageProducer imageProducer) throws JimiException {
        return Jimi.createRasterImage(imageProducer, 4);
    }

    public static JimiRasterImage createRasterImage(ImageProducer imageProducer, int n) throws JimiException {
        if (imageProducer instanceof QueuedImageProducerProxy) {
            imageProducer = ((QueuedImageProducerProxy)imageProducer).getImageProducer();
        }
        if (imageProducer instanceof JimiRasterImage) {
            return (JimiRasterImage)((Object)imageProducer);
        }
        return Jimi.createRasterImage(imageProducer, Jimi.getFactory(n));
    }

    protected static JimiRasterImage createRasterImage(ImageProducer imageProducer, JimiImageFactory jimiImageFactory) throws JimiException {
        while (jimiImageFactory instanceof JimiImageFactoryProxy) {
            jimiImageFactory = ((JimiImageFactoryProxy)jimiImageFactory).getProxiedFactory();
        }
        return JimiRasterImageImporter.importImage(imageProducer, jimiImageFactory);
    }

    public static JimiReader createTypedJimiReader(InputStream inputStream, String string) throws JimiException {
        return Jimi.createTypedJimiReader(inputStream, string);
    }

    public static JimiReader createTypedJimiReader(InputStream inputStream, String string, int n) throws JimiException {
        return new JimiReader(Jimi.getFactory(n), inputStream, string);
    }

    public static JimiReader createTypedJimiReader(String string) throws JimiException {
        return Jimi.createTypedJimiReader(string, defaultFlags);
    }

    public static JimiReader createTypedJimiReader(String string, int n) throws JimiException {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n));
        jimiReader.setMimeType(string);
        return jimiReader;
    }

    public static JimiWriter createTypedJimiWriter(String string) throws JimiException {
        return new JimiWriter(null, string);
    }

    public static String[] getDecoderTypes() {
        String[] stringArray = new String[JimiControl.mimeToDecoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToDecoderMap.keys();
        int n = 0;
        while (n < stringArray.length && enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static String[] getEncoderTypes() {
        String[] stringArray = new String[JimiControl.mimeToEncoderMap.size()];
        Enumeration enumeration = JimiControl.mimeToEncoderMap.keys();
        int n = 0;
        while (n < stringArray.length && enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static JimiImageFactory getFactory(int n) {
        if ((n & 0x10) != 0) {
            return oneshotFactory;
        }
        if ((n & 8) != 0) {
            if (vmemFactory == null) {
                if (limited) {
                    vmemFactory = memoryFactory;
                }
                try {
                    Class<?> clazz = Class.forName("com.sun.jimi.core.VMemJimiImageFactory");
                    vmemFactory = (JimiImageFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    vmemFactory = memoryFactory;
                }
            }
            return vmemFactory;
        }
        return memoryFactory;
    }

    public static Image getImage(InputStream inputStream) {
        return Jimi.getImage(inputStream, defaultFlags);
    }

    public static Image getImage(InputStream inputStream, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(inputStream, n));
    }

    public static Image getImage(InputStream inputStream, String string) {
        return Jimi.getImage(inputStream, string, defaultFlags);
    }

    public static Image getImage(InputStream inputStream, String string, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(inputStream, string, n));
    }

    public static Image getImage(String string) {
        return Jimi.getImage(string, defaultFlags);
    }

    public static Image getImage(String string, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(string, n));
    }

    public static Image getImage(String string, String string2) {
        return Jimi.getImage(string, string2, defaultFlags);
    }

    public static Image getImage(String string, String string2, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(string, string2, n));
    }

    public static Image getImage(URL uRL) {
        return Jimi.getImage(uRL, defaultFlags);
    }

    public static Image getImage(URL uRL, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(uRL, n));
    }

    public static Image getImage(URL uRL, String string) {
        return Jimi.getImage(uRL, string, defaultFlags);
    }

    public static Image getImage(URL uRL, String string, int n) {
        return Toolkit.getDefaultToolkit().createImage(Jimi.getImageProducer(uRL, string, n));
    }

    public static ImageProducer getImageProducer(InputStream inputStream) {
        return Jimi.getImageProducer(inputStream, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream inputStream, int n) {
        try {
            JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), inputStream);
            jimiReader.setBlocking(JimiUtil.flagSet(n, 2));
            return jimiReader.getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(InputStream inputStream, String string) {
        return Jimi.getImageProducer(inputStream, string, defaultFlags);
    }

    public static ImageProducer getImageProducer(InputStream inputStream, String string, int n) {
        try {
            JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), inputStream, string);
            jimiReader.setBlocking(JimiUtil.flagSet(n, 2));
            return jimiReader.getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String string) {
        return Jimi.getImageProducer(string, defaultFlags);
    }

    public static ImageProducer getImageProducer(String string, int n) {
        try {
            JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), string);
            jimiReader.setBlocking(JimiUtil.flagSet(n, 2));
            return jimiReader.getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(String string, String string2) {
        return Jimi.getImageProducer(string, string2, defaultFlags);
    }

    public static ImageProducer getImageProducer(String string, String string2, int n) {
        try {
            JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), string, string2);
            jimiReader.setBlocking(JimiUtil.flagSet(n, 2));
            return jimiReader.getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL uRL) {
        return Jimi.getImageProducer(uRL, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL uRL, int n) {
        try {
            JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), uRL);
            return jimiReader.getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static ImageProducer getImageProducer(URL uRL, String string) {
        return Jimi.getImageProducer(uRL, string, defaultFlags);
    }

    public static ImageProducer getImageProducer(URL uRL, String string, int n) {
        try {
            JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), uRL, string);
            return jimiReader.getImageProducer();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImageProducer();
        }
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream) throws JimiException {
        return Jimi.getRasterImage(inputStream, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream, int n) throws JimiException {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), inputStream);
        return jimiReader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream, String string) throws JimiException {
        return Jimi.getRasterImage(inputStream, string, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(InputStream inputStream, String string, int n) throws JimiException {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), inputStream, string);
        return jimiReader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(String string) throws JimiException {
        return Jimi.getRasterImage(string, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(String string, int n) throws JimiException {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), string);
        jimiReader.setBlocking(JimiUtil.flagSet(n, 2));
        return jimiReader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL uRL) throws JimiException {
        return Jimi.getRasterImage(uRL, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL uRL, int n) throws JimiException {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), uRL);
        return jimiReader.getRasterImage();
    }

    public static JimiRasterImage getRasterImage(URL uRL, String string) throws JimiException {
        return Jimi.getRasterImage(uRL, string, defaultFlags);
    }

    public static JimiRasterImage getRasterImage(URL uRL, String string, int n) throws JimiException {
        JimiReader jimiReader = new JimiReader(Jimi.getFactory(n), uRL, string);
        return jimiReader.getRasterImage();
    }

    static void init() {
    }

    public static void main(String[] stringArray) {
        block6: {
            block7: {
                block5: {
                    if (stringArray.length == 0) {
                        System.err.println("Usage: Jimi <-version | -encoders | -decoders>");
                    }
                    if (!stringArray[0].equals("-version")) break block5;
                    try {
                        Properties properties = new Properties();
                        properties.load((class$com$sun$jimi$core$Jimi != null ? class$com$sun$jimi$core$Jimi : (class$com$sun$jimi$core$Jimi = Jimi.class$("com.sun.jimi.core.Jimi"))).getResourceAsStream("version"));
                        System.out.println("Jimi version: " + properties.getProperty("jimi.version") + " (build " + properties.getProperty("jimi.build") + ")");
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to read version information: " + exception.toString());
                    }
                    break block6;
                }
                if (!stringArray[0].equals("-encoders")) break block7;
                System.out.println("Supported encoder mimetypes:");
                String[] stringArray2 = Jimi.getEncoderTypes();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
                break block6;
            }
            if (!stringArray[0].equals("-decoders")) break block6;
            System.out.println("Supported decoder mimetypes:");
            String[] stringArray3 = Jimi.getDecoderTypes();
            int n = 0;
            while (n < stringArray3.length) {
                System.out.println(stringArray3[n]);
                ++n;
            }
        }
    }

    public static void putImage(JimiImage jimiImage, String string) throws JimiException {
        JimiWriter jimiWriter = new JimiWriter(string);
        jimiWriter.setSource(jimiImage);
        jimiWriter.putImage(string);
    }

    public static void putImage(Image image, String string) throws JimiException {
        Jimi.putImage(image.getSource(), string);
    }

    public static void putImage(ImageProducer imageProducer, String string) throws JimiException {
        Jimi.putImage(Jimi.createRasterImage(imageProducer), string);
    }

    public static void putImage(String string, JimiImage jimiImage, OutputStream outputStream) throws JimiException {
        JimiWriter jimiWriter = new JimiWriter(outputStream, string);
        jimiWriter.setSource(jimiImage);
        jimiWriter.putImage(outputStream);
    }

    public static void putImage(String string, JimiImage jimiImage, String string2) throws JimiException {
        JimiWriter jimiWriter = new JimiWriter(string2, string);
        jimiWriter.setSource(jimiImage);
        jimiWriter.putImage(string2);
    }

    public static void putImage(String string, Image image, OutputStream outputStream) throws JimiException {
        Jimi.putImage(string, image.getSource(), outputStream);
    }

    public static void putImage(String string, Image image, String string2) throws JimiException {
        JimiWriter jimiWriter = new JimiWriter(string2, string);
        jimiWriter.setSource(image);
        jimiWriter.putImage(string2);
    }

    public static void putImage(String string, ImageProducer imageProducer, OutputStream outputStream) throws JimiException {
        Jimi.putImage(string, (JimiImage)Jimi.createRasterImage(imageProducer), outputStream);
    }

    public static void putImage(String string, ImageProducer imageProducer, String string2) throws JimiException {
        JimiWriter jimiWriter = new JimiWriter(string2, string);
        jimiWriter.setSource(imageProducer);
        jimiWriter.putImage(string2);
    }

    public static void setDefaultFlags(int n) {
        defaultFlags = n;
    }
}

