/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class PageMapper {
    protected RandomAccessStorage storage;
    protected Dimension logicalSize;
    protected int pageFrameMemory;
    protected int pageFaults = 0;
    protected OutputStream output;
    protected InputStream input;
    protected int numberOfPageFrames;
    protected Dimension pageDimensions;

    public PageMapper(RandomAccessStorage randomAccessStorage, Dimension dimension, int n) {
        this.storage = randomAccessStorage;
        this.logicalSize = dimension;
        this.pageFrameMemory = n;
        this.output = randomAccessStorage.asOutputStream();
        this.input = randomAccessStorage.asInputStream();
        this.configurePageFrames();
    }

    public void commitPage(PageFrame pageFrame) throws IOException {
        int n = this.getPageSize() * pageFrame.getLogicalPageNumber();
        this.storage.seek(n);
        pageFrame.writeTo(this.output);
        this.output.flush();
        pageFrame.setModified(false);
    }

    protected void configurePageFrames() {
        this.pageDimensions = new Dimension(this.logicalSize.width / 8, 200);
        this.numberOfPageFrames = 9;
    }

    public Dimension getLogicalSize() {
        return this.logicalSize;
    }

    public PageFrame getPageFrame(int n) throws IOException {
        PageFrame[] pageFrameArray = this.getPageFrames();
        long l = Long.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < pageFrameArray.length) {
            if (pageFrameArray[n3].getLogicalPageNumber() == n) {
                pageFrameArray[n3].touch();
                return pageFrameArray[n3];
            }
            if (pageFrameArray[n3].lastTouched() < l) {
                n2 = n3;
                l = pageFrameArray[n3].lastTouched();
            }
            ++n3;
        }
        ++this.pageFaults;
        PageFrame pageFrame = pageFrameArray[n2];
        if (pageFrame.isModified()) {
            this.commitPage(pageFrame);
        }
        this.readPageIntoFrame(pageFrame, n);
        return pageFrame;
    }

    public PageFrame getPageFrameForReading(int n) throws IOException {
        return this.getPageFrame(n);
    }

    public PageFrame getPageFrameForWriting(int n) throws IOException {
        PageFrame pageFrame = this.getPageFrame(n);
        pageFrame.setModified(true);
        return pageFrame;
    }

    public abstract PageFrame[] getPageFrames();

    public abstract int getPageSize();

    protected abstract int getPixelSize();

    public int howManyPageFaults() {
        return this.pageFaults;
    }

    public void readPageIntoFrame(PageFrame pageFrame, int n) throws IOException {
        int n2 = this.getPageSize() * n;
        this.storage.seek(n2);
        try {
            pageFrame.readFrom(this.input);
        }
        catch (IOException iOException) {}
        pageFrame.setLogicalPageNumber(n);
        pageFrame.setModified(false);
        pageFrame.touch();
    }

    public void resetPageFaultCount() {
        this.pageFaults = 0;
    }
}

