/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mdconfig.MetadataElementValidatorDateCH;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class MetadataElementValidatorDateRangeCH
implements MetadataElementValidator {
    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return;
        }
        String[] dates = value.split(" *- *");
        if (dates.length > 2) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateRangeCHInvalidNumberOfValues", (Object[])new Object[]{value}));
        }
        for (String date : dates) {
            new MetadataElementValidatorDateCH().check(date, context, metadataElement);
        }
        if (dates.length == 2) {
            if (dates[0].split("\\.").length != dates[1].split("\\.").length) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateRangeCHDifferentFormats", (Object[])new Object[]{value}));
            }
            SimpleDateFormat df = switch (dates[0].split("\\.").length) {
                case 1 -> new SimpleDateFormat("yyyy");
                case 2 -> new SimpleDateFormat("M.yyyy");
                case 3 -> new SimpleDateFormat("d.M.yyyy");
                default -> throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{value}));
            };
            df.setLenient(false);
            try {
                if (df.parse(dates[0]).after(df.parse(dates[1]))) {
                    throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateRangeCHNotValid", (Object[])new Object[]{value}));
                }
            }
            catch (ParseException e) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{value}));
            }
        }
    }
}

