/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Library;

public class EmbeddedFileStream
extends Dictionary {
    public static final Name PARAMS_KEY = new Name("Params");
    public static final Name PARAMS_SIZE_KEY = new Name("Size");
    public static final Name PARAMS_CREATION_DATE_KEY = new Name("CreationDate");
    public static final Name PARAMS_MOD_DATE_KEY = new Name("ModDate");
    public static final Name PARAMS_MAC_KEY = new Name("Mac");
    public static final Name PARAMS_MAC_SUBTYPE_KEY = new Name("Subtype");
    public static final Name PARAMS_MAC_CREATOR_KEY = new Name("Creator");
    public static final Name PARAMS_MAC_RES_FORK_KEY = new Name("ResFork");
    public static final Name PARAMS_CHECK_SUM_KEY = new Name("CheckSum");
    protected Stream fileStream;
    private SecurityManager securityManager;

    public EmbeddedFileStream(Library library, Stream fileStream) {
        super(library, fileStream.getEntries());
        this.securityManager = library.getSecurityManager();
        this.fileStream = fileStream;
    }

    public Name getType() {
        return this.library.getName(this.entries, TYPE_KEY);
    }

    public Name getSubType() {
        return this.library.getName(this.entries, SUBTYPE_KEY);
    }

    public HashMap getParams() {
        return this.library.getDictionary(this.entries, PARAMS_KEY);
    }

    public int getParamUncompressedSize() {
        int size = this.library.getInt(this.getParams(), PARAMS_SIZE_KEY);
        if (size == 0) {
            size = this.fileStream.getDecodedStreamBytes().length;
        }
        return size;
    }

    public int getCompressedSize() {
        return this.fileStream.getRawBytes().length;
    }

    public InputStream getDecodedStreamData() throws IOException {
        return this.fileStream.getDecodedByteArrayInputStream();
    }

    public PDate getParamCreationData() {
        Object value = this.library.getObject(this.getParams(), PARAMS_CREATION_DATE_KEY);
        if (value != null && value instanceof StringObject) {
            StringObject text = (StringObject)value;
            return new PDate(this.securityManager, text.getDecryptedLiteralString(this.securityManager));
        }
        return null;
    }

    public PDate getParamLastModifiedData() {
        Object value = this.library.getObject(this.getParams(), PARAMS_MOD_DATE_KEY);
        if (value != null && value instanceof StringObject) {
            StringObject text = (StringObject)value;
            return new PDate(this.securityManager, text.getDecryptedLiteralString(this.securityManager));
        }
        return null;
    }

    public HashMap getMacDictionary() {
        return this.library.getDictionary(this.getParams(), PARAMS_MAC_KEY);
    }

    public String getCheckSum() {
        Object value = this.library.getObject(this.getParams(), PARAMS_CHECK_SUM_KEY);
        if (value != null && value instanceof StringObject) {
            StringObject text = (StringObject)value;
            return text.getDecryptedLiteralString(this.securityManager);
        }
        return null;
    }
}

