/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.AbstractKeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingKeyProvider;
import net.java.truecommons.key.spec.prompting.SharedKeyManager;

@ThreadSafe
public final class PromptingKeyManager<K extends PromptingKey<K>>
extends AbstractKeyManager<K> {
    private final SharedKeyManager<K> manager = new SharedKeyManager();
    private final PromptingKey.View<K> view;

    public PromptingKeyManager(PromptingKey.View<K> view) {
        this.view = Objects.requireNonNull(view);
    }

    PromptingKey.View<K> getView() {
        return this.view;
    }

    @Override
    public KeyProvider<K> provider(URI uri) {
        return new PromptingKeyProvider<K>(this, Objects.requireNonNull(uri), this.manager.provider(uri));
    }

    @Override
    public void release(URI uri) {
        this.manager.release(Objects.requireNonNull(uri));
    }

    @Override
    public void link(URI originUri, URI targetUri) {
        this.manager.link(Objects.requireNonNull(originUri), Objects.requireNonNull(targetUri));
    }

    @Override
    public void unlink(URI uri) {
        this.manager.unlink(Objects.requireNonNull(uri));
    }

    @Override
    public String toString() {
        return String.format("%s[view=%s]", this.getClass().getName(), this.getView());
    }
}

