/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.HashMap;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    public static final Name TYPE_KEY = new Name("Type");
    public static final Name SUBTYPE_KEY = new Name("Subtype");
    public static final Name LENGTH_KEY = new Name("Length");
    public static final Name FORM_TYPE_KEY = new Name("FormType");
    protected Library library;
    protected HashMap<Object, Object> entries;
    protected boolean inited;
    protected boolean isDeleted;
    protected boolean isNew;
    private Reference pObjectReference;

    public Dictionary(Library library, HashMap entries) {
        this.library = library;
        this.entries = entries;
        if (this.entries == null) {
            this.entries = new HashMap();
        }
    }

    public void setPObjectReference(Reference reference) {
        this.pObjectReference = reference;
    }

    public Reference getPObjectReference() {
        return this.pObjectReference;
    }

    public void init() throws InterruptedException {
    }

    public HashMap<Object, Object> getEntries() {
        return this.entries;
    }

    public Object getObject(Name key) {
        return this.library.getObject(this.entries, key);
    }

    protected Number getNumber(Name key) {
        return this.library.getNumber(this.entries, key);
    }

    public int getInt(Name key) {
        return this.library.getInt(this.entries, key);
    }

    public float getFloat(Name key) {
        return this.library.getFloat(this.entries, key);
    }

    public Library getLibrary() {
        return this.library;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    protected String setString(Name key, String value) {
        this.entries.put(key, new LiteralStringObject(value, this.getPObjectReference(), this.library.getSecurityManager()));
        return value;
    }

    protected String setHexString(Name key, String value) {
        this.entries.put(key, new HexStringObject(value, this.getPObjectReference(), this.library.getSecurityManager()));
        return value;
    }

    public String toString() {
        return this.getClass().getName() + "=" + this.entries.toString();
    }
}

