/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.multisequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ByteUtils;

public final class MultiSequenceUtils {
    private MultiSequenceUtils() {
    }

    public static List<SequenceMatcher> reverseMatchers(Collection<? extends SequenceMatcher> matchers) {
        ArrayList<SequenceMatcher> reversedMatchers = new ArrayList<SequenceMatcher>(matchers.size());
        for (SequenceMatcher sequenceMatcher : matchers) {
            reversedMatchers.add(sequenceMatcher.reverse());
        }
        return reversedMatchers;
    }

    public static Set<Byte> bytesAlignedLeft(int atPosition, MultiSequenceMatcher matcher) {
        HashSet<Byte> bytes = new HashSet<Byte>();
        if (atPosition >= 0 && atPosition < matcher.getMaximumLength()) {
            for (SequenceMatcher sequence : matcher.getSequenceMatchers()) {
                if (atPosition >= sequence.length()) continue;
                ByteMatcher lastMatcher = sequence.getMatcherForPosition(atPosition);
                byte[] bytesForPosition = lastMatcher.getMatchingBytes();
                ByteUtils.addAll(bytesForPosition, bytes);
            }
        }
        return bytes;
    }

    public static Set<Byte> bytesAlignedRight(int atPosition, MultiSequenceMatcher matcher) {
        HashSet<Byte> bytes = new HashSet<Byte>();
        if (atPosition >= 0 && atPosition < matcher.getMaximumLength()) {
            for (SequenceMatcher sequence : matcher.getSequenceMatchers()) {
                int sequencePosition = sequence.length() - atPosition - 1;
                if (sequencePosition < 0) continue;
                ByteMatcher lastMatcher = sequence.getMatcherForPosition(sequencePosition);
                byte[] bytesForPosition = lastMatcher.getMatchingBytes();
                ByteUtils.addAll(bytesForPosition, bytes);
            }
        }
        return bytes;
    }
}

