/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.AbstractSearcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.utils.ArgUtils;

public abstract class AbstractMultiSequenceSearcher
extends AbstractSearcher<SequenceMatcher> {
    protected final MultiSequenceMatcher sequences;

    public AbstractMultiSequenceSearcher(MultiSequenceMatcher sequences) {
        ArgUtils.checkNullObject(sequences, "sequences");
        this.sequences = sequences;
    }

    public MultiSequenceMatcher getMatcher() {
        return this.sequences;
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        int longestMatchEndPosition = this.sequences.getMaximumLength() - 1;
        long l = searchPosition = fromPosition > 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastWindowPosition;
            long lastSearchPosition;
            List<SearchResult<SequenceMatcher>> readerResult;
            int arrayLastPosition;
            long windowStartPosition = window.getWindowPosition();
            int windowLength = window.length();
            int arrayStartPosition = reader.getWindowOffset(searchPosition);
            if (arrayStartPosition + longestMatchEndPosition <= (arrayLastPosition = windowLength - 1)) {
                long distanceToEnd = toPosition - windowStartPosition;
                int lastMatchingPosition = arrayLastPosition - longestMatchEndPosition;
                int arrayMaxPosition = distanceToEnd < (long)lastMatchingPosition ? (int)distanceToEnd : lastMatchingPosition;
                List arrayResult = this.searchForwards(window.getArray(), arrayStartPosition, arrayMaxPosition);
                if (!arrayResult.isEmpty()) {
                    long readerOffset = searchPosition - (long)arrayStartPosition;
                    return SearchUtils.addPositionToResults(arrayResult, readerOffset);
                }
                if ((searchPosition += (long)(arrayMaxPosition - arrayStartPosition + 1)) > toPosition) {
                    return SearchUtils.noResults();
                }
            }
            if (!(readerResult = this.doSearchForwards(reader, searchPosition, lastSearchPosition = toPosition < (lastWindowPosition = windowStartPosition + (long)arrayLastPosition) ? toPosition : lastWindowPosition)).isEmpty()) {
                return readerResult;
            }
            searchPosition = lastSearchPosition + 1L;
        }
        return SearchUtils.noResults();
    }

    protected abstract List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader var1, long var2, long var4) throws IOException;

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int smallestMatchEndPosition = this.sequences.getMinimumLength() - 1;
        int longestMatchEndPosition = this.sequences.getMaximumLength() - 1;
        long finalSearchPosition = toPosition > 0L ? toPosition : 0L;
        long searchPosition = this.withinLength(reader, fromPosition);
        while (searchPosition >= finalSearchPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastCrossingPosition;
            List<SearchResult<SequenceMatcher>> readerResult;
            int searchEndPosition;
            int searchStartPosition = reader.getWindowOffset(searchPosition);
            long windowStartPosition = window.getWindowPosition();
            long distanceToEnd = finalSearchPosition - windowStartPosition;
            int n = searchEndPosition = distanceToEnd > 0L ? (int)distanceToEnd : 0;
            if (searchStartPosition - smallestMatchEndPosition >= searchEndPosition) {
                byte[] array = window.getArray();
                List arrayResult = this.searchBackwards(array, searchStartPosition, searchEndPosition);
                if (!arrayResult.isEmpty()) {
                    long readerOffset = searchPosition - (long)searchStartPosition;
                    return SearchUtils.addPositionToResults(arrayResult, readerOffset);
                }
                int bytesSearched = searchStartPosition - searchEndPosition;
                if ((searchPosition -= (long)(bytesSearched + 1)) < finalSearchPosition) {
                    return SearchUtils.noResults();
                }
            }
            if (!(readerResult = this.doSearchBackwards(reader, searchPosition, lastCrossingPosition = windowStartPosition - (long)longestMatchEndPosition)).isEmpty()) {
                return readerResult;
            }
            searchPosition = lastCrossingPosition - 1L;
        }
        return SearchUtils.noResults();
    }

    protected abstract List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader var1, long var2, long var4) throws IOException;

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sequences + ")";
    }
}

