/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core;

import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import uk.gov.nationalarchives.droid.core.IdentificationRequestByteReaderAdapter;
import uk.gov.nationalarchives.droid.core.SignatureFileParser;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.FileFormatCollection;
import uk.gov.nationalarchives.droid.core.signature.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;

public class BinarySignatureIdentifier
implements DroidCore {
    private FFSignatureFile sigFile;
    private SignatureFileParser sigFileParser = new SignatureFileParser();
    private URI signatureFile;

    public void init() throws SignatureParseException {
        this.sigFile = this.sigFileParser.parseSigFile(Paths.get(this.signatureFile));
        this.sigFile.prepareForUse();
    }

    public void setSignatureFile(String signatureFile) {
        this.signatureFile = Paths.get(signatureFile, new String[0]).toUri();
    }

    public IdentificationResultCollection matchBinarySignatures(IdentificationRequest request) {
        IdentificationResultCollection results = new IdentificationResultCollection(request);
        results.setRequestMetaData(request.getRequestMetaData());
        IdentificationRequestByteReaderAdapter byteReader = new IdentificationRequestByteReaderAdapter(request);
        this.sigFile.runFileIdentification(byteReader);
        int numHits = byteReader.getNumHits();
        for (int i = 0; i < numHits; ++i) {
            FileFormatHit hit = byteReader.getHit(i);
            IdentificationResultImpl result = new IdentificationResultImpl();
            result.setMimeType(hit.getMimeType());
            result.setName(hit.getFileFormatName());
            result.setVersion(hit.getFileFormatVersion());
            result.setPuid(hit.getFileFormatPUID());
            result.setMethod(IdentificationMethod.BINARY_SIGNATURE);
            results.addResult((IdentificationResult)result);
        }
        results.setFileLength(Long.valueOf(request.size()));
        results.setRequestMetaData(request.getRequestMetaData());
        return results;
    }

    public IdentificationResultCollection matchExtensions(IdentificationRequest request, boolean allExtensions) {
        List<FileFormat> fileFormats;
        IdentificationResultCollection results = new IdentificationResultCollection(request);
        results.setRequestMetaData(request.getRequestMetaData());
        String fileExtension = request.getExtension();
        if (fileExtension != null && !fileExtension.isEmpty() && (fileFormats = allExtensions ? this.sigFile.getFileFormatsForExtension(fileExtension) : this.sigFile.getTentativeFormatsForExtension(fileExtension)) != null) {
            int numFormats = fileFormats.size();
            for (int i = 0; i < numFormats; ++i) {
                FileFormat format = fileFormats.get(i);
                IdentificationResultImpl result = new IdentificationResultImpl();
                result.setName(format.getName());
                result.setVersion(format.getVersion());
                result.setPuid(format.getPUID());
                result.setMimeType(format.getMimeType());
                result.setMethod(IdentificationMethod.EXTENSION);
                results.addResult((IdentificationResult)result);
            }
        }
        results.setFileLength(Long.valueOf(request.size()));
        results.setRequestMetaData(request.getRequestMetaData());
        return results;
    }

    public void removeSignatureForPuid(String puid) {
        this.sigFile.puidHasOverridingSignatures(puid);
    }

    public FFSignatureFile getSigFile() {
        return this.sigFile;
    }

    public void setMaxBytesToScan(long maxBytes) {
        this.sigFile.setMaxBytesToScan(maxBytes);
    }

    public void removeLowerPriorityHits(IdentificationResultCollection results) {
        IdentificationResult result;
        int i;
        FileFormatCollection allFormats = this.sigFile.getFileFormatCollection();
        HashSet<Integer> lowerPriorityIDs = new HashSet<Integer>();
        List theResults = results.getResults();
        int numResults = theResults.size();
        for (int i2 = 0; i2 < numResults; ++i2) {
            IdentificationResult result2 = (IdentificationResult)theResults.get(i2);
            String resultPUID = result2.getPuid();
            FileFormat format = allFormats.getFormatForPUID(resultPUID);
            lowerPriorityIDs.addAll(format.getFormatIdsHasPriorityOver());
        }
        ArrayList<IdentificationResult> lowerPriorityResults = new ArrayList<IdentificationResult>();
        for (i = 0; i < numResults; ++i) {
            result = (IdentificationResult)theResults.get(i);
            String resultPUID = result.getPuid();
            FileFormat format = allFormats.getFormatForPUID(resultPUID);
            if (!lowerPriorityIDs.contains(format.getID())) continue;
            lowerPriorityResults.add(result);
        }
        numResults = lowerPriorityResults.size();
        for (i = 0; i < numResults; ++i) {
            result = (IdentificationResult)lowerPriorityResults.get(i);
            results.removeResult(result);
        }
    }

    public void checkForExtensionsMismatches(IdentificationResultCollection results, String fileExtension) {
        if (fileExtension == null || fileExtension.isEmpty()) {
            FileFormatCollection allFormats = this.sigFile.getFileFormatCollection();
            List theResults = results.getResults();
            int numResults = theResults.size();
            for (int i = 0; i < numResults; ++i) {
                IdentificationResult result = (IdentificationResult)theResults.get(i);
                String resultPUID = result.getPuid();
                FileFormat format = allFormats.getFormatForPUID(resultPUID);
                if (format.getNumExtensions() <= 0) continue;
                results.setExtensionMismatch(Boolean.valueOf(true));
                break;
            }
        } else {
            FileFormatCollection allFormats = this.sigFile.getFileFormatCollection();
            List theResults = results.getResults();
            int numResults = theResults.size();
            for (int i = 0; i < numResults; ++i) {
                IdentificationResult result = (IdentificationResult)theResults.get(i);
                String resultPUID = result.getPuid();
                FileFormat format = allFormats.getFormatForPUID(resultPUID);
                if (!format.hasExtensionMismatch(fileExtension)) continue;
                results.setExtensionMismatch(Boolean.valueOf(true));
                break;
            }
        }
    }

    public String formatNameByPuid(String puid) {
        FileFormat format = this.sigFile.getFileFormat(puid);
        return format != null ? format.getName() : null;
    }
}

