/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import net.byteseek.io.reader.WindowReader;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;

public final class ByteseekWindowWrapper
implements SeekableByteChannel {
    private static final String NOT_IMPLEMENTED = "This method from the SeekableByteChannel interface is not implemented";
    private final WindowReader reader;
    private final boolean closeReaderIfClosed;
    private boolean closed;
    private long currentPosition;

    public ByteseekWindowWrapper(WindowReader reader) {
        this(reader, false);
    }

    public ByteseekWindowWrapper(WindowReader reader, boolean closeReaderIfClosed) {
        this.reader = reader;
        this.closeReaderIfClosed = closeReaderIfClosed;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (this.currentPosition >= this.size()) {
            return -1;
        }
        int bytesCopied = ArchiveFileUtils.copyToBuffer(this.reader, this.currentPosition, dst);
        this.currentPosition += (long)bytesCopied;
        return bytesCopied;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public long position() throws IOException {
        return this.currentPosition;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.currentPosition = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.reader.length();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.closeReaderIfClosed) {
            this.reader.close();
        }
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

