/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform.signature;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.x509.util.StreamParsingException;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.AlgorithmIdentifier;
import org.icepdf.core.pobjects.acroform.signature.Pkcs7Validator;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.certificates.CertificateVerifier;
import org.icepdf.core.pobjects.acroform.signature.exceptions.CertificateVerificationException;
import org.icepdf.core.pobjects.acroform.signature.exceptions.RevocationVerificationException;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SelfSignedVerificationException;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPkcsValidator
implements SignatureValidator {
    private static final Logger logger = Logger.getLogger(AbstractPkcsValidator.class.toString());
    private static String caCertLocation = "/lib/security/cacerts";
    public static final String ID_DATA_OBJECT_IDENTIFIER;
    public static final String ID_SIGNED_DATA_OBJECT_IDENTIFIER;
    public static final String ID_ENVELOPED_DATA_OBJECT_IDENTIFIER;
    public static final String ID_DIGESTED_DATA_OBJECT_IDENTIFIER;
    public static final String ID_ENCRYPTED_DATA_OBJECT_IDENTIFIER;
    private static final String ALGORITHM_WITH = "with";
    protected SignatureFieldDictionary signatureFieldDictionary;
    protected Collection<Certificate> certificateChain;
    protected X509Certificate signerCertificate;
    protected String digestAlgorithmIdentifier;
    protected String signatureAlgorithmIdentifier;
    protected ASN1Set signedAttributesSequence;
    protected byte[] encapsulatedContentInfoData;
    protected byte[] messageDigest;
    protected byte[] signatureValue;
    private boolean isSignedDataModified = true;
    private boolean isDocumentDataModified;
    private boolean isSignaturesCoverDocumentLength;
    private boolean isCertificateChainTrusted;
    private boolean isCertificateDateValid = true;
    private boolean isRevocation;
    private boolean isSelfSigned;
    private boolean isSignerTimeValid;
    private boolean isEmbeddedTimeStamp;
    private Date lastVerified;
    protected boolean initialized;

    public AbstractPkcsValidator(SignatureFieldDictionary signatureFieldDictionary) throws SignatureIntegrityException {
        this.signatureFieldDictionary = signatureFieldDictionary;
        if (!this.initialized) {
            this.init();
        }
    }

    @Override
    public abstract void validate() throws SignatureIntegrityException;

    protected void announceSignatureType(SignatureDictionary signatureDictionary) {
        if (logger.isLoggable(Level.FINE)) {
            Name preferredHandler = signatureDictionary.getFilter();
            Name encoding = signatureDictionary.getSubFilter();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Signature Handler: " + preferredHandler);
                logger.finer("         Encoding: " + encoding);
                logger.finer("Starting Validation");
            }
        }
    }

    protected void parseSignerData(ASN1Sequence signedData, byte[] cmsData) throws SignatureIntegrityException {
        ASN1TaggedObject unsignedAttributes;
        ASN1Set unsignedAttributeSequence;
        AttributeTable attributeTable;
        Attribute timeStamp;
        String eObjectIdentifierId;
        ASN1ObjectIdentifier eObjectIdentifier;
        if (logger.isLoggable(Level.FINER)) {
            int cmsVersion = ((ASN1Integer)signedData.getObjectAt(0)).getValue().intValue();
            logger.finest("CMS version: " + cmsVersion);
            Enumeration enumeration = ((ASN1Set)signedData.getObjectAt(1)).getObjects();
            while (enumeration.hasMoreElements()) {
                String objectId = ((ASN1ObjectIdentifier)((ASN1Sequence)enumeration.nextElement()).getObjectAt(0)).getId();
                try {
                    String digestAlgorithmName = AlgorithmIdentifier.getDigestAlgorithmName(objectId);
                    MessageDigest tmp = AlgorithmIdentifier.getDigestInstance(objectId, null);
                    logger.finest("DigestAlgorithmIdentifiers: " + digestAlgorithmName + " " + objectId);
                    logger.finest(tmp.toString());
                }
                catch (Throwable ex) {
                    logger.log(Level.WARNING, "Error finding iod: " + objectId, ex);
                }
            }
        }
        this.encapsulatedContentInfoData = null;
        ASN1Sequence encapsulatedContentInfo = (ASN1Sequence)signedData.getObjectAt(2);
        if (encapsulatedContentInfo.size() >= 2) {
            eObjectIdentifier = (ASN1ObjectIdentifier)encapsulatedContentInfo.getObjectAt(0);
            eObjectIdentifierId = eObjectIdentifier.getId();
            if (logger.isLoggable(Level.FINER)) {
                logger.finest("EncapsulatedContentInfo: " + eObjectIdentifierId + " " + Pkcs7Validator.getObjectIdName(eObjectIdentifierId));
            }
            ASN1OctetString eContent = (ASN1OctetString)((ASN1TaggedObject)encapsulatedContentInfo.getObjectAt(1)).getObject();
            this.encapsulatedContentInfoData = eContent.getOctets();
            if (logger.isLoggable(Level.FINER)) {
                logger.finest("EncapsulatedContentInfo Data " + eContent.toString());
            }
        } else if (encapsulatedContentInfo.size() == 1 && logger.isLoggable(Level.FINER)) {
            eObjectIdentifier = (ASN1ObjectIdentifier)encapsulatedContentInfo.getObjectAt(0);
            eObjectIdentifierId = eObjectIdentifier.getId();
            logger.finest("EncapsulatedContentInfo size is 1: " + eObjectIdentifierId + " " + Pkcs7Validator.getObjectIdName(eObjectIdentifierId));
        }
        ASN1Sequence signerInfo = this.parseCertificateData(cmsData, signedData);
        this.digestAlgorithmIdentifier = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(2)).getObjectAt(0)).getId();
        int nextEntry = 3;
        this.messageDigest = null;
        this.signedAttributesSequence = null;
        if (signerInfo.getObjectAt(nextEntry) instanceof ASN1TaggedObject) {
            ASN1TaggedObject signedAttributes = (ASN1TaggedObject)signerInfo.getObjectAt(nextEntry);
            this.signedAttributesSequence = ASN1Set.getInstance((ASN1TaggedObject)signedAttributes, (boolean)false);
            int max = this.signedAttributesSequence.size();
            for (int i = 0; i < max; ++i) {
                ASN1Sequence attributePair = (ASN1Sequence)this.signedAttributesSequence.getObjectAt(i);
                if (!((ASN1ObjectIdentifier)attributePair.getObjectAt(0)).getId().equals(PKCSObjectIdentifiers.pkcs_9_at_messageDigest.getId())) continue;
                ASN1Set set = (ASN1Set)attributePair.getObjectAt(1);
                this.messageDigest = ((ASN1OctetString)set.getObjectAt(0)).getOctets();
            }
            if (this.messageDigest == null) {
                throw new SignatureIntegrityException("Message Digest can nut be null");
            }
            ++nextEntry;
        }
        this.signatureAlgorithmIdentifier = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(nextEntry)).getObjectAt(0)).getId();
        this.signatureValue = ((ASN1OctetString)signerInfo.getObjectAt(++nextEntry)).getOctets();
        if (++nextEntry < signerInfo.size() && signerInfo.getObjectAt(nextEntry) instanceof ASN1TaggedObject && (timeStamp = (attributeTable = new AttributeTable(unsignedAttributeSequence = ASN1Set.getInstance((ASN1TaggedObject)(unsignedAttributes = (ASN1TaggedObject)signerInfo.getObjectAt(nextEntry)), (boolean)false))).get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null && timeStamp.getAttrValues().size() > 0) {
            ASN1Set attributeValues = timeStamp.getAttrValues();
            ASN1Sequence tokenSequence = ASN1Sequence.getInstance((Object)attributeValues.getObjectAt(0));
            ContentInfo contentInfo = ContentInfo.getInstance((Object)tokenSequence);
            try {
                new TimeStampToken(contentInfo);
                this.isEmbeddedTimeStamp = true;
            }
            catch (Throwable e1) {
                throw new SignatureIntegrityException("Valid TimeStamp could now be created");
            }
        }
    }

    private ASN1Sequence parseCertificateData(byte[] cmsData, ASN1Sequence signedData) throws SignatureIntegrityException {
        X509CertParser x509CertParser = new X509CertParser();
        x509CertParser.engineInit((InputStream)new ByteArrayInputStream(cmsData));
        try {
            this.certificateChain = x509CertParser.engineReadAll();
        }
        catch (StreamParsingException e) {
            logger.log(Level.WARNING, "Error parsing certificate data: ", e);
            throw new SignatureIntegrityException("Error parsing certificate data ");
        }
        ASN1Set signerInfos = (ASN1Set)signedData.getObjectAt(signedData.size() - 1);
        ASN1Sequence signerInfo = (ASN1Sequence)signerInfos.getObjectAt(0);
        int signerVersion = ((ASN1Integer)signerInfo.getObjectAt(0)).getValue().intValue();
        ASN1Sequence issuerAndSerialNumber = (ASN1Sequence)signerInfo.getObjectAt(1);
        this.signerCertificate = null;
        if (signerVersion == 1) {
            X500Principal issuer;
            try {
                issuer = new X500Principal(issuerAndSerialNumber.getObjectAt(0).toASN1Primitive().getEncoded());
            }
            catch (IOException e1) {
                logger.warning("Could not create X500 Principle data ");
                throw new SignatureIntegrityException("Could not create X500 Principle data");
            }
            BigInteger serialNumber = ((ASN1Integer)issuerAndSerialNumber.getObjectAt(1)).getValue();
            this.signerCertificate = null;
            for (Certificate element : this.certificateChain) {
                X509Certificate certificate = (X509Certificate)element;
                if (certificate.getIssuerX500Principal().equals(issuer) && serialNumber.equals(certificate.getSerialNumber())) {
                    this.signerCertificate = certificate;
                    break;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Certificate and issuer could not be verified as the same entity.");
            }
        } else if (signerVersion == 3) {
            throw new IllegalStateException("Singer version 3 not supported");
        }
        return signerInfo;
    }

    protected ASN1Sequence captureSignedData(byte[] cmsData) throws SignatureIntegrityException {
        ASN1Sequence cmsSequence = this.buildASN1Primitive(cmsData);
        if (cmsSequence == null || cmsSequence.getObjectAt(0) == null) {
            throw new SignatureIntegrityException("ContentInfo does not contain content type.");
        }
        ASN1ObjectIdentifier objectIdentifier = (ASN1ObjectIdentifier)cmsSequence.getObjectAt(0);
        if (!(objectIdentifier != null && (ID_DATA_OBJECT_IDENTIFIER.equals(objectIdentifier.getId()) || ID_DIGESTED_DATA_OBJECT_IDENTIFIER.equals(objectIdentifier.getId()) || ID_ENCRYPTED_DATA_OBJECT_IDENTIFIER.equals(objectIdentifier.getId()) || ID_ENVELOPED_DATA_OBJECT_IDENTIFIER.equals(objectIdentifier.getId()) || ID_SIGNED_DATA_OBJECT_IDENTIFIER.equals(objectIdentifier.getId())))) {
            logger.warning("ANSI object id is not a valid PKCS7 identifier " + objectIdentifier);
            throw new SignatureIntegrityException("ANSI object id is not a valid PKCS7 identifier");
        }
        logger.finest("Object identifier: " + objectIdentifier.getId() + " " + Pkcs7Validator.getObjectIdName(objectIdentifier.getId()));
        if (!ID_SIGNED_DATA_OBJECT_IDENTIFIER.equals(objectIdentifier.getId())) {
            throw new SignatureIntegrityException("ANSI.1 object must be of type Signed Data");
        }
        return (ASN1Sequence)((ASN1TaggedObject)cmsSequence.getObjectAt(1)).getObject();
    }

    protected boolean verifySignedAttributes(String provider, X509Certificate signerCertificate, byte[] signatureValue, String signatureAlgorithmIdentifier, String digestAlgorithmIdentifier, byte[] attr) throws SignatureIntegrityException {
        try {
            Signature signature = this.createSignature(signerCertificate.getPublicKey(), provider, signatureAlgorithmIdentifier, digestAlgorithmIdentifier);
            signature.update(attr);
            return signature.verify(signatureValue);
        }
        catch (InvalidKeyException e) {
            throw new SignatureIntegrityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureIntegrityException(e);
        }
        catch (SignatureException e) {
            throw new SignatureIntegrityException(e);
        }
    }

    protected Signature createSignature(PublicKey publicKey, String provider, String signatureAlgorithmIdentifier, String digestAlgorithmIdentifier) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature;
        String encryptionAlgorithmName = AlgorithmIdentifier.getEncryptionAlgorithmName(signatureAlgorithmIdentifier);
        String digestAlgorithmName = AlgorithmIdentifier.getDigestAlgorithmName(digestAlgorithmIdentifier);
        String digestAlgorithm = digestAlgorithmName + ALGORITHM_WITH + encryptionAlgorithmName;
        logger.finest("DigestAlgorithm " + digestAlgorithm);
        if (provider != null) {
            try {
                signature = Signature.getInstance(digestAlgorithm, provider);
            }
            catch (NoSuchProviderException e) {
                signature = Signature.getInstance(digestAlgorithm);
            }
        } else {
            signature = Signature.getInstance(digestAlgorithm);
        }
        signature.initVerify(publicKey);
        return signature;
    }

    protected ASN1Sequence buildASN1Primitive(byte[] cmsData) {
        try {
            ASN1InputStream abstractSyntaxNotationStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(cmsData));
            ASN1Primitive pkcs = abstractSyntaxNotationStream.readObject();
            if (pkcs instanceof ASN1Sequence) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finest("ASN1Sequence found starting sequence processing.  ");
                }
                return (ASN1Sequence)pkcs;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finest("ASN1Sequence was not found backing out.  ");
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "ASN1 stream could not be read.", e);
        }
        return null;
    }

    protected static String getObjectIdName(String objectId) {
        if (ID_DATA_OBJECT_IDENTIFIER.equals(objectId)) {
            return "ID Data Object Identifier";
        }
        if (ID_SIGNED_DATA_OBJECT_IDENTIFIER.equals(objectId)) {
            return "ID Signed Data Object Identifier";
        }
        if (ID_ENVELOPED_DATA_OBJECT_IDENTIFIER.equals(objectId)) {
            return "ID Enveloped Data Object Identifier";
        }
        if (ID_ENCRYPTED_DATA_OBJECT_IDENTIFIER.equals(objectId)) {
            return "ID Encrypted Data Object Identifier";
        }
        if (ID_DIGESTED_DATA_OBJECT_IDENTIFIER.equals(objectId)) {
            return "ID Digested Data Object Identifier";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateDocument() throws SignatureIntegrityException {
        Signature signature;
        MessageDigest eConMessageDigestAlgorithm;
        MessageDigest messageDigestAlgorithm;
        SignatureDictionary signatureDictionary = this.signatureFieldDictionary.getSignatureDictionary();
        try {
            String provider = signatureDictionary.getFilter().getName();
            messageDigestAlgorithm = AlgorithmIdentifier.getDigestInstance(this.digestAlgorithmIdentifier, provider);
            eConMessageDigestAlgorithm = AlgorithmIdentifier.getDigestInstance(this.digestAlgorithmIdentifier, provider);
            signature = this.createSignature(this.signerCertificate.getPublicKey(), provider, this.signatureAlgorithmIdentifier, this.digestAlgorithmIdentifier);
            PublicKey publicKey = this.signerCertificate.getPublicKey();
            if (logger.isLoggable(Level.FINER)) {
                logger.finest("Certificate: \n" + this.signerCertificate.toString());
                logger.finest("Public Key:  \n" + publicKey);
            }
        }
        catch (NoSuchProviderException e1) {
            logger.log(Level.WARNING, "No such provider found ", e1);
            return;
        }
        catch (NoSuchAlgorithmException e1) {
            logger.log(Level.WARNING, "No such algorithm found ", e1);
            return;
        }
        catch (InvalidKeyException e1) {
            logger.log(Level.WARNING, "Invalid key ", e1);
            return;
        }
        ArrayList<Integer> byteRange = this.signatureFieldDictionary.getSignatureDictionary().getByteRange();
        SeekableInput documentInput = this.signatureFieldDictionary.getLibrary().getDocumentInput();
        documentInput.beginThreadAccess();
        try {
            long totalLength = documentInput.getLength();
            long digestedLength = byteRange.get(2) + byteRange.get(3);
            if (digestedLength < totalLength) {
                this.isDocumentDataModified = true;
            }
            documentInput.seekAbsolute(byteRange.get(0).intValue());
            byte[] firstSection = new byte[byteRange.get(1).intValue()];
            documentInput.read(firstSection);
            messageDigestAlgorithm.update(firstSection);
            documentInput.seekAbsolute(byteRange.get(2).intValue());
            byte[] secondSection = new byte[byteRange.get(3).intValue()];
            documentInput.read(secondSection);
            messageDigestAlgorithm.update(secondSection);
        }
        catch (IOException e) {
            throw new SignatureIntegrityException(e);
        }
        finally {
            documentInput.endThreadAccess();
        }
        try {
            byte[] documentDigestBytes = messageDigestAlgorithm.digest();
            if (this.signedAttributesSequence != null) {
                boolean encapsulatedDigestCheck = true;
                boolean verifyEncContentInfoData = true;
                if (this.encapsulatedContentInfoData != null) {
                    verifyEncContentInfoData = Arrays.equals(documentDigestBytes, this.encapsulatedContentInfoData);
                    eConMessageDigestAlgorithm.update(this.encapsulatedContentInfoData);
                    encapsulatedDigestCheck = Arrays.equals(eConMessageDigestAlgorithm.digest(), this.messageDigest);
                }
                boolean nonEncapsulatedDigestCheck = Arrays.equals(documentDigestBytes, this.messageDigest);
                boolean isSignatureValid = this.verifySignedAttributes(signatureDictionary.getFilter().getName(), this.signerCertificate, this.signatureValue, this.signatureAlgorithmIdentifier, this.digestAlgorithmIdentifier, this.signedAttributesSequence.getEncoded("DER"));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Encapsulated Digest verified: " + encapsulatedDigestCheck);
                    logger.finest("Non-encapsulated Digest verified: " + nonEncapsulatedDigestCheck);
                    logger.finest("Signature verified: " + isSignatureValid);
                    logger.finest("Encapsulated data verified: " + verifyEncContentInfoData);
                }
                if ((encapsulatedDigestCheck || nonEncapsulatedDigestCheck) && verifyEncContentInfoData) {
                    this.isSignedDataModified = false;
                }
            } else {
                boolean nonEncapsulatedDigestCheck;
                if (this.encapsulatedContentInfoData != null) {
                    signature.update(messageDigestAlgorithm.digest());
                }
                if (nonEncapsulatedDigestCheck = Arrays.equals(documentDigestBytes, this.messageDigest)) {
                    this.isSignedDataModified = false;
                }
            }
            this.lastVerified = new Date();
        }
        catch (SignatureException e) {
            throw new SignatureIntegrityException(e);
        }
        catch (IOException e) {
            throw new SignatureIntegrityException(e);
        }
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(caCertLocation);
                trustStore.load(fis, null);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            X509Certificate[] cers = this.certificateChain.toArray(new X509Certificate[0]);
            ArrayList<X509Certificate> trusted = new ArrayList<X509Certificate>(trustStore.size());
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                trusted.add((X509Certificate)trustStore.getCertificate(aliases.nextElement()));
            }
            CertificateVerifier.verifyCertificate(cers[0], trusted);
            this.isCertificateChainTrusted = true;
            this.isCertificateDateValid = true;
            this.lastVerified = new Date();
        }
        catch (CertificateExpiredException e) {
            logger.log(Level.FINEST, "Certificate chain could not be validated, certificate is expired", e);
            this.isCertificateDateValid = false;
        }
        catch (SelfSignedVerificationException e) {
            logger.log(Level.FINEST, "Certificate chain could not be validated, signature is self singed.", e);
            this.isSelfSigned = true;
        }
        catch (CertificateVerificationException e) {
            logger.log(Level.FINEST, "Certificate chain could not be validated. ", e);
            this.isCertificateChainTrusted = false;
        }
        catch (RevocationVerificationException e) {
            logger.log(Level.FINEST, "Certificate chain could not be validated, certificate has been revoked.", e);
            this.isRevocation = true;
        }
        catch (IOException e) {
            logger.log(Level.FINEST, "Error locating trusted keystore .", e);
            this.isCertificateChainTrusted = false;
        }
        catch (CertificateException e) {
            logger.log(Level.FINEST, "Certificate exception.", e);
            this.isCertificateChainTrusted = false;
        }
        catch (Throwable e) {
            logger.log(Level.FINEST, "Error validation certificate chain.", e);
            this.isCertificateChainTrusted = false;
        }
    }

    @Override
    public boolean checkByteRange() throws SignatureIntegrityException {
        if (this.signatureFieldDictionary == null) {
            return false;
        }
        ArrayList<Integer> byteRange = this.signatureFieldDictionary.getSignatureDictionary().getByteRange();
        SeekableInput documentInput = this.signatureFieldDictionary.getLibrary().getDocumentInput();
        documentInput.beginThreadAccess();
        try {
            long totalLength = documentInput.getLength();
            long digestedLength = byteRange.get(2) + byteRange.get(3);
            if (digestedLength == totalLength) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw new SignatureIntegrityException(e);
        }
        finally {
            documentInput.endThreadAccess();
        }
        return false;
    }

    @Override
    public X509Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    @Override
    public Collection<Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public Date getLastValidated() {
        return this.lastVerified;
    }

    @Override
    public boolean isSignedDataModified() {
        return this.isSignedDataModified;
    }

    @Override
    public boolean isDocumentDataModified() {
        return this.isDocumentDataModified;
    }

    @Override
    public boolean isSignaturesCoverDocumentLength() {
        return this.isSignaturesCoverDocumentLength;
    }

    @Override
    public void setSignaturesCoverDocumentLength(boolean signaturesCoverDocumentLength) {
        this.isSignaturesCoverDocumentLength = signaturesCoverDocumentLength;
    }

    @Override
    public boolean isCertificateChainTrusted() {
        return this.isCertificateChainTrusted;
    }

    @Override
    public boolean isRevocation() {
        return this.isRevocation;
    }

    @Override
    public boolean isSelfSigned() {
        return this.isSelfSigned;
    }

    @Override
    public boolean isCertificateDateValid() {
        return this.isCertificateDateValid;
    }

    @Override
    public boolean isEmbeddedTimeStamp() {
        return this.isEmbeddedTimeStamp;
    }

    @Override
    public boolean isSignerTimeValid() {
        return false;
    }

    static {
        String javaHome = Defs.sysProperty("java.home");
        caCertLocation = Defs.sysProperty("org.icepdf.core.signatures.caCertPath", javaHome + caCertLocation);
        ID_DATA_OBJECT_IDENTIFIER = PKCSObjectIdentifiers.data.getId();
        ID_SIGNED_DATA_OBJECT_IDENTIFIER = PKCSObjectIdentifiers.signedData.getId();
        ID_ENVELOPED_DATA_OBJECT_IDENTIFIER = PKCSObjectIdentifiers.envelopedData.getId();
        ID_DIGESTED_DATA_OBJECT_IDENTIFIER = PKCSObjectIdentifiers.digestedData.getId();
        ID_ENCRYPTED_DATA_OBJECT_IDENTIFIER = PKCSObjectIdentifiers.encryptedData.getId();
    }
}

