/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.premis;

import ch.docuteam.darc.admin.BuildInfo;
import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.mets.metshdr.Header;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.darc.premis.ObjectRelationship;
import ch.docuteam.tools.file.FileChecksumCalculator;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.id.UniqueID;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;

public class Object
extends NodeAbstract {
    private static final String Xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String Xmlns_xlink = "http://www.w3.org/1999/xlink";
    private static final String CompositionLevel = "0";
    private static final String FormatRegistryName = "PRONOM";
    private static final String TypeFile = "PREMIS:file";
    private static final String TypeRepresentation = "PREMIS:representation";
    public static final String IDType = "Docuteam";
    protected List<ObjectRelationship> relationships = new ArrayList<ObjectRelationship>();
    private static final String DerivedFromRelationshipType = "derivation";
    private static final String DerivedFromRelationshipSubType = "derived from";
    private static final String ReplacementForRelationshipType = "replacement";
    private static final String ReplacementForRelationshipSubType = "replacement for";
    private static final String SourceForRelationshipType = "source";
    private static final String SourceForRelationshipSubType = "source for";
    private static final String Xlink_type = "simple";
    private static FileChecksumCalculator.Algorithm DefaultMessageDigestAlgorithm = FileChecksumCalculator.Algorithm.SHA512;
    protected String type = "";
    protected String idType = "Docuteam";
    protected String compositionLevel = "0";
    protected String messageDigestAlgorithm = DefaultMessageDigestAlgorithm.getCode();
    protected String messageDigest = "";
    protected String size = "";
    protected String formatName = "";
    protected String formatRegistryName = "PRONOM";
    protected String formatRegistryKey = "";
    protected String originalName = "";
    protected String swName = "";
    protected String swType = "";

    public Object(DigiprovWithPremis parent, Element parentElement, ch.docuteam.darc.mets.structmap.NodeAbstract node) {
        this.parent = parent;
        this.document = parent.getDocument();
        this.id = UniqueID.getXML();
        this.originalName = node.getLabel();
        this.type = node.isFile() ? TypeFile : TypeRepresentation;
        this.element = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"object", (Namespace)parentElement.getNamespace()));
        this.element.addAttribute(new QName("type", new Namespace("xsi", Xmlns_xsi)), this.type);
        parentElement.content().add(this.indexOfLastObject(parentElement) + 1, this.element);
        Element objectIdentifier = this.element.addElement("PREMIS:objectIdentifier");
        objectIdentifier.addElement("PREMIS:objectIdentifierType").addText(this.idType);
        objectIdentifier.addElement("PREMIS:objectIdentifierValue").addText(this.id);
        if (node.isFile()) {
            this.size = node.getSize().toString();
            try {
                this.messageDigest = DefaultMessageDigestAlgorithm.getDigest(node.getAbsolutePathString());
            }
            catch (Exception e) {
                ch.docuteam.tools.exception.Exception.remember((Throwable)e);
            }
            IdentificationResult identificationResult = null;
            try {
                identificationResult = MetadataProviderDROID.getIdentificationResult((String)node.getAbsolutePathString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (identificationResult != null) {
                this.formatName = identificationResult.getName();
                this.formatRegistryKey = identificationResult.getPuid();
            }
            if (this.formatName == null) {
                this.formatName = "";
            }
            if (this.formatRegistryKey == null) {
                this.formatRegistryKey = "";
            }
            Element objectCharacteristics = this.element.addElement("PREMIS:objectCharacteristics");
            objectCharacteristics.addElement("PREMIS:compositionLevel").addText(this.compositionLevel);
            Element fixity = objectCharacteristics.addElement("PREMIS:fixity");
            fixity.addElement("PREMIS:messageDigestAlgorithm").addText(this.messageDigestAlgorithm);
            fixity.addElement("PREMIS:messageDigest").addText(this.messageDigest);
            objectCharacteristics.addElement("PREMIS:size").addText(this.size);
            Element format = objectCharacteristics.addElement("PREMIS:format");
            Element formatDesignation = format.addElement("PREMIS:formatDesignation");
            formatDesignation.addElement("PREMIS:formatName").addText(this.formatName);
            Element formatRegistry = format.addElement("PREMIS:formatRegistry");
            formatRegistry.addElement("PREMIS:formatRegistryName").addText(this.formatRegistryName);
            formatRegistry.addElement("PREMIS:formatRegistryKey").addText(this.formatRegistryKey);
        }
        this.element.addElement("PREMIS:originalName").addAttribute(new QName("type", new Namespace("xlink", Xmlns_xlink)), Xlink_type).addText(this.originalName);
    }

    public Object(DigiprovWithPremis parent, Element parentElement, Header header) {
        this.parent = parent;
        this.document = parent.getDocument();
        this.id = UniqueID.getXML();
        this.type = TypeRepresentation;
        this.swName = BuildInfo.getProduct();
        this.swType = BuildInfo.getVersion();
        this.element = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"object", (Namespace)parentElement.getNamespace())).addAttribute(new QName("type", new Namespace("xsi", Xmlns_xsi)), this.type);
        parentElement.content().add(this.indexOfLastObject(parentElement) + 1, this.element);
        Element objectIdentifier = this.element.addElement("PREMIS:objectIdentifier");
        objectIdentifier.addElement("PREMIS:objectIdentifierType").addText(this.idType);
        objectIdentifier.addElement("PREMIS:objectIdentifierValue").addText(this.id);
        Element software = this.element.addElement("PREMIS:environment").addElement("PREMIS:software");
        software.addElement("PREMIS:swName").addText(this.swName);
        software.addElement("PREMIS:swType").addText(this.swType);
    }

    private Object(DigiprovWithPremis parent, Element objectElement) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = objectElement;
        this.type = objectElement.attributeValue("type");
        this.idType = this.getElementText("./PREMIS:objectIdentifier/PREMIS:objectIdentifierType", true);
        this.id = this.getElementText("./PREMIS:objectIdentifier/PREMIS:objectIdentifierValue", true);
        this.compositionLevel = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:compositionLevel", false);
        this.messageDigestAlgorithm = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:fixity/PREMIS:messageDigestAlgorithm", false);
        this.messageDigest = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:fixity/PREMIS:messageDigest", false);
        this.size = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:size", false);
        this.formatName = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:format/PREMIS:formatDesignation/PREMIS:formatName", false);
        this.formatRegistryName = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:format/PREMIS:formatRegistry/PREMIS:formatRegistryName", false);
        this.formatRegistryKey = this.getElementText("./PREMIS:objectCharacteristics/PREMIS:format/PREMIS:formatRegistry/PREMIS:formatRegistryKey", false);
        this.originalName = this.getElementText("./PREMIS:originalName", false);
        this.swName = this.getElementText("./PREMIS:environment/PREMIS:software/PREMIS:swName", false);
        this.swType = this.getElementText("./PREMIS:environment/PREMIS:software/PREMIS:swType", false);
        List relationshipNodes = this.element.selectNodes("./PREMIS:relationship");
        for (Node currentRelationNode : relationshipNodes) {
            this.relationships.add(new ObjectRelationship(parent, (Element)currentRelationNode));
        }
    }

    public static List<Object> parse(DigiprovWithPremis parent, Element premisElement) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (java.lang.Object o : premisElement.selectNodes("./PREMIS:object")) {
            objectList.add(new Object(parent, (Element)o));
        }
        return objectList;
    }

    public static FileChecksumCalculator.Algorithm getDefaultMessageDigestAlgorithm() {
        return DefaultMessageDigestAlgorithm;
    }

    public static void setDefaultMessageDigestAlgorithm(FileChecksumCalculator.Algorithm defaultMessageDigestAlgorithm) {
        DefaultMessageDigestAlgorithm = defaultMessageDigestAlgorithm;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getType() {
        return this.type;
    }

    public String getCompositionLevel() {
        return this.compositionLevel;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public String getMessageDigest() {
        return this.messageDigest;
    }

    public String getSize() {
        return this.size;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String newFormatName) {
        this.formatName = newFormatName;
        this.element.selectSingleNode(".//PREMIS:formatName").setText(this.formatName);
        this.document.setIsModified();
    }

    public List<ObjectRelationship> getRelationships() {
        return this.relationships;
    }

    public String getFormatRegistryName() {
        return this.formatRegistryName;
    }

    public String getFormatRegistryKey() {
        return this.formatRegistryKey;
    }

    public void setFormatRegistryKey(String newFormatRegistryKey) {
        this.formatRegistryKey = newFormatRegistryKey;
        this.element.selectSingleNode(".//PREMIS:formatRegistryKey").setText(this.formatRegistryKey);
        this.document.setIsModified();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String newOriginalName) {
        this.originalName = newOriginalName;
        this.element.selectSingleNode("PREMIS:originalName").setText(this.originalName);
        this.document.setIsModified();
    }

    public void addDerivedFromRelationship(Event event) {
        this.relationships.add(new ObjectRelationship(this.parent, this.element, DerivedFromRelationshipType, DerivedFromRelationshipSubType, event.getLinkingObjectIdValue(), event.getId()));
    }

    public void addReplacementForRelationship(Event event) {
        this.relationships.add(new ObjectRelationship(this.parent, this.element, ReplacementForRelationshipType, ReplacementForRelationshipSubType, event.getLinkingObjectIdValue(), event.getId()));
    }

    public void addSourceForRelationship(Event event, Object relatedObject) {
        this.relationships.add(new ObjectRelationship(this.parent, this.element, SourceForRelationshipType, SourceForRelationshipSubType, relatedObject.id, event.getId()));
    }

    public String getSwName() {
        return this.swName;
    }

    public String getSwType() {
        return this.swType;
    }

    public void setSwNameAndType() {
        this.swName = BuildInfo.getProduct();
        this.swType = BuildInfo.getVersion();
        this.element.selectSingleNode("PREMIS:environment/PREMIS:software/PREMIS:swName").setText(this.swName);
        this.element.selectSingleNode("PREMIS:environment/PREMIS:software/PREMIS:swType").setText(this.swType);
        this.document.setIsModified();
    }

    private int indexOfLastObject(Element parentElement) {
        for (int i = parentElement.content().size() - 1; i >= 0; --i) {
            if (!"object".equals(((Node)parentElement.content().get(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[PREMISObject:id=").append(this.id).append("(").append(this.type).append("/").append(this.formatName).append("/").append(this.formatRegistryName).append("/").append(this.formatRegistryKey).append("/").append(this.originalName).append("/").append(this.swName).append("/").append(this.swType).append(")");
        for (ObjectRelationship currentRelation : this.relationships) {
            stringBuilder.append(currentRelation.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

