/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.premis;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.premis.ObjectRelationshipRelatedEvent;
import ch.docuteam.darc.premis.ObjectRelationshipRelatedObject;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class ObjectRelationship
extends NodeAbstract {
    protected String relationshipType = "";
    protected String relationshipSubType = "";
    protected String relatedObjectIdentification = "";
    protected List<ObjectRelationshipRelatedObject> relatedObjects = new ArrayList<ObjectRelationshipRelatedObject>();
    protected List<ObjectRelationshipRelatedEvent> relatedEvents = new ArrayList<ObjectRelationshipRelatedEvent>();

    public ObjectRelationship(DigiprovWithPremis parent, Element objectElement) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = objectElement;
        this.relationshipType = this.getElementText("./PREMIS:relationshipType", true);
        this.relationshipSubType = this.getElementText("./PREMIS:relationshipSubType", true);
        List relatedObjects = this.element.selectNodes("./PREMIS:relatedObjectIdentification");
        for (Node currentRelationNode : relatedObjects) {
            this.relatedObjects.add(new ObjectRelationshipRelatedObject(parent, (Element)currentRelationNode));
        }
        List relatedEvents = this.element.selectNodes("./PREMIS:relatedEventIdentification");
        for (Node currentRelationNode : relatedEvents) {
            this.relatedEvents.add(new ObjectRelationshipRelatedEvent(parent, (Element)currentRelationNode));
        }
    }

    public ObjectRelationship(NodeAbstract parent, Element objectElement, String relationshipType, String relationshipSubType, String relatedObjectIdValue, String relatedEventIdValue) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = objectElement;
        List siblings = objectElement.selectNodes("./PREMIS:relationship | ./PREMIS:environment | ./PREMIS:originalName | ./PREMIS:significantProperties | ./PREMIS:preservationLevel | ./PREMIS:objectIdentifier");
        assert (!siblings.isEmpty());
        int index = objectElement.elements().indexOf(siblings.get(siblings.size() - 1));
        Element relationship = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"relationship", (Namespace)objectElement.getNamespace()));
        objectElement.elements().add(index + 1, relationship);
        relationship.addElement("PREMIS:relationshipType").addText(relationshipType);
        relationship.addElement("PREMIS:relationshipSubType").addText(relationshipSubType);
        this.relationshipType = relationshipType;
        this.relationshipSubType = relationshipSubType;
        this.relatedObjects.add(new ObjectRelationshipRelatedObject(parent, relationship, "Docuteam", relatedObjectIdValue));
        this.relatedEvents.add(new ObjectRelationshipRelatedEvent(parent, relationship, "Docuteam", relatedEventIdValue));
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getRelationshipSubType() {
        return this.relationshipSubType;
    }

    public String getRelatedObjectIdentification() {
        return this.relatedObjectIdentification;
    }

    public List<ObjectRelationshipRelatedObject> getRelatedObjects() {
        return this.relatedObjects;
    }

    public List<ObjectRelationshipRelatedEvent> getRelatedEvents() {
        return this.relatedEvents;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Relationship:").append("(").append(this.relationshipType).append("/").append(this.relationshipSubType);
        for (ObjectRelationshipRelatedObject relatedObj : this.getRelatedObjects()) {
            stringBuilder.append(relatedObj.toString());
        }
        for (ObjectRelationshipRelatedEvent relatedEvent : this.getRelatedEvents()) {
            stringBuilder.append(relatedEvent.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

