/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcRecordBase;
import org.jwat.common.ByteCountingPushBackInputStream;

public class ArcReaderUncompressed
extends ArcReader {
    public static final int PUSHBACK_BUFFER_SIZE = 32;
    protected ByteCountingPushBackInputStream in;
    protected long startOffset = -1L;

    public ArcReaderUncompressed() {
        this.init();
    }

    public ArcReaderUncompressed(ByteCountingPushBackInputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        this.in = in;
        this.init();
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public void close() {
        if (this.currentRecord != null) {
            try {
                this.currentRecord.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.currentRecord = null;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
    }

    @Override
    protected void recordClosed() {
        if (this.currentRecord != null) {
            this.consumed += this.currentRecord.consumed;
        } else {
            throw new IllegalStateException("'currentRecord' is null, this should never happen!");
        }
    }

    @Override
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    public long getOffset() {
        if (this.in != null) {
            return this.in.getConsumed();
        }
        return this.consumed;
    }

    @Override
    public long getConsumed() {
        if (this.in != null) {
            return this.in.getConsumed();
        }
        return this.consumed;
    }

    @Override
    public ArcRecordBase getNextRecord() throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
        }
        if (this.in == null) {
            throw new IllegalStateException("This reader has been initialized with an incompatible constructor, 'in' is null");
        }
        this.currentRecord = ArcRecordBase.parseRecord(this.in, this);
        if (this.currentRecord != null) {
            this.startOffset = this.currentRecord.header.startOffset;
        }
        return this.currentRecord;
    }

    @Override
    public ArcRecordBase getNextRecordFrom(InputStream rin, long offset) throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
        }
        if (this.in != null) {
            throw new IllegalStateException("This reader has been initialized with an incompatible constructor, 'in' is not null");
        }
        if (rin == null) {
            throw new IllegalArgumentException("The inputstream 'rin' is null");
        }
        if (offset < -1L) {
            throw new IllegalArgumentException("The 'offset' is less than -1: " + offset);
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(rin, 32);
        this.currentRecord = ArcRecordBase.parseRecord(pbin, this);
        if (this.currentRecord != null) {
            this.startOffset = offset;
            this.currentRecord.header.startOffset = offset;
        }
        return this.currentRecord;
    }

    @Override
    public ArcRecordBase getNextRecordFrom(InputStream rin, long offset, int buffer_size) throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
        }
        if (this.in != null) {
            throw new IllegalStateException("This reader has been initialized with an incompatible constructor, 'in' is not null");
        }
        if (rin == null) {
            throw new IllegalArgumentException("The inputstream 'rin' is null");
        }
        if (offset < -1L) {
            throw new IllegalArgumentException("The 'offset' is less than -1: " + offset);
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(new BufferedInputStream(rin, buffer_size), 32);
        this.currentRecord = ArcRecordBase.parseRecord(pbin, this);
        if (this.currentRecord != null) {
            this.startOffset = offset;
            this.currentRecord.header.startOffset = offset;
        }
        return this.currentRecord;
    }
}

