/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.IOException;
import java.io.StringReader;

public class CharCountingStringReader
extends StringReader {
    protected long consumed = 0L;
    protected long counter = 0L;

    public CharCountingStringReader(String str) {
        super(str);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getConsumed() {
        return this.consumed;
    }

    public void setCounter(long bytes) {
        this.counter = bytes;
    }

    public long getCounter() {
        return this.counter;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.consumed;
            ++this.counter;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytesRead = super.read(cbuf, off, len);
        if (bytesRead > 0) {
            this.consumed += (long)bytesRead;
            this.counter += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = super.skip(n);
        this.consumed += bytesSkipped;
        this.counter += bytesSkipped;
        return bytesSkipped;
    }

    public String readLine() throws IOException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.read()) == -1) {
                return null;
            }
            if (c == 10) break;
            if (c == 13) continue;
            buf.append((char)c);
        }
        return buf.toString();
    }
}

