/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Date;
import org.jwat.arc.ArcConstants;
import org.jwat.arc.ArcFieldParsers;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcWriter;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.ContentType;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.HeaderLine;
import org.jwat.common.Scheme;
import org.jwat.common.Uri;
import org.jwat.common.UriProfile;

public class ArcHeader {
    protected ArcReader reader;
    protected Diagnostics<Diagnosis> diagnostics;
    protected UriProfile uriProfile;
    protected ArcFieldParsers fieldParsers;
    protected long startOffset = -1L;
    public int recordFieldVersion;
    protected boolean hasCompliantFields = false;
    public String urlStr;
    public Uri urlUri;
    public String urlScheme;
    public String ipAddressStr;
    public InetAddress inetAddress;
    public String archiveDateStr;
    public Date archiveDate;
    public String contentTypeStr;
    public ContentType contentType;
    public String resultCodeStr;
    public Integer resultCode;
    public String checksumStr;
    public String locationStr;
    public String offsetStr;
    public Long offset;
    public String filenameStr;
    public String archiveLengthStr;
    public Long archiveLength;
    public byte[] headerBytes;

    protected ArcHeader() {
    }

    public static ArcHeader initHeader(ArcFieldParsers fieldParsers, UriProfile uriProfile, Diagnostics<Diagnosis> diagnostics) {
        ArcHeader header = new ArcHeader();
        header.fieldParsers = fieldParsers;
        header.uriProfile = uriProfile;
        header.fieldParsers = fieldParsers;
        header.diagnostics = diagnostics;
        return header;
    }

    public static ArcHeader initHeader(ArcWriter writer, Diagnostics<Diagnosis> diagnostics) {
        ArcHeader header = new ArcHeader();
        header.fieldParsers = writer.fieldParsers;
        header.diagnostics = diagnostics;
        return header;
    }

    public static ArcHeader initHeader(ArcReader reader, long startOffset, Diagnostics<Diagnosis> diagnostics) {
        ArcHeader header = new ArcHeader();
        header.reader = reader;
        header.uriProfile = reader.uriProfile;
        header.fieldParsers = reader.fieldParsers;
        header.diagnostics = diagnostics;
        header.startOffset = startOffset;
        return header;
    }

    public boolean parseHeader(ByteCountingPushBackInputStream in) throws IOException {
        boolean bHeaderParsed = false;
        boolean bInvalidDataBeforeVersion = false;
        boolean bEmptyLinesBeforeVersion = false;
        boolean bSeekRecord = true;
        while (bSeekRecord) {
            this.startOffset = in.getConsumed();
            HeaderLine recordLine = HeaderLine.readLine((InputStream)in);
            if (recordLine != null) {
                if (recordLine.line.length() > 0) {
                    String[] fields = recordLine.line.split(" ", -1);
                    if (fields.length == ArcConstants.VERSION_1_BLOCK_NUMBER_FIELDS || fields.length == ArcConstants.VERSION_2_BLOCK_NUMBER_FIELDS) {
                        this.parseHeaders(fields);
                        bHeaderParsed = true;
                        this.headerBytes = recordLine.raw;
                        bSeekRecord = false;
                        continue;
                    }
                    bInvalidDataBeforeVersion = true;
                    continue;
                }
                bEmptyLinesBeforeVersion = true;
                continue;
            }
            bSeekRecord = false;
        }
        if (bInvalidDataBeforeVersion) {
            this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID, "Data before ARC record", new String[0]));
        }
        if (bEmptyLinesBeforeVersion) {
            this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID, "Empty lines before ARC record", new String[0]));
        }
        return bHeaderParsed;
    }

    public void parseHeaders(String[] fields) {
        if (fields.length == ArcConstants.VERSION_1_BLOCK_FIELDS.length || fields.length == ArcConstants.VERSION_2_BLOCK_FIELDS.length) {
            this.recordFieldVersion = 1;
            this.urlStr = fields[0];
            if ("-".equals(this.urlStr)) {
                this.urlStr = null;
            }
            this.urlUri = this.fieldParsers.parseUri(this.urlStr, this.uriProfile, "URL", false);
            if (this.urlUri != null) {
                this.urlScheme = this.urlUri.getScheme();
            } else if (this.urlStr != null) {
                this.urlScheme = Scheme.getScheme((String)this.urlStr);
            }
            if (this.urlScheme != null) {
                this.urlScheme = this.urlScheme.toLowerCase();
            }
            this.ipAddressStr = fields[1];
            if ("-".equals(this.ipAddressStr)) {
                this.ipAddressStr = null;
            }
            this.inetAddress = this.fieldParsers.parseIpAddress(this.ipAddressStr, "IP-address", false);
            this.archiveDateStr = fields[2];
            if ("-".equals(this.archiveDateStr)) {
                this.archiveDateStr = null;
            }
            this.archiveDate = this.fieldParsers.parseDate(this.archiveDateStr, "Archive-date", false);
            this.contentTypeStr = fields[3];
            if ("-".equals(this.contentTypeStr)) {
                this.contentTypeStr = null;
            }
            if (!"no-type".equalsIgnoreCase(this.contentTypeStr)) {
                this.contentType = this.fieldParsers.parseContentType(this.contentTypeStr, "Content-type", false);
            }
            if (fields.length == ArcConstants.VERSION_2_BLOCK_FIELDS.length) {
                this.recordFieldVersion = 2;
                this.resultCodeStr = fields[4];
                if ("-".equals(this.resultCodeStr)) {
                    this.resultCodeStr = null;
                }
                this.resultCode = this.fieldParsers.parseInteger(this.resultCodeStr, "Result-code", false);
                if (this.resultCode != null && (this.resultCode < 100 || this.resultCode > 999)) {
                    this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Result-code' value", new String[]{this.resultCodeStr, "A number between 100 and 999"}));
                }
                this.checksumStr = fields[5];
                if ("-".equals(this.checksumStr)) {
                    this.checksumStr = null;
                }
                this.checksumStr = this.fieldParsers.parseString(this.checksumStr, "Checksum", true);
                this.locationStr = fields[6];
                if ("-".equals(this.locationStr)) {
                    this.locationStr = null;
                }
                this.locationStr = this.fieldParsers.parseString(this.locationStr, "Location", true);
                this.offsetStr = fields[7];
                if ("-".equals(this.offsetStr)) {
                    this.offsetStr = null;
                }
                this.offset = this.fieldParsers.parseLong(this.offsetStr, "Offset", false);
                if (this.offset != null && this.offset < 0L) {
                    this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Offset' value", new String[]{this.offsetStr, "A non negative number"}));
                }
                this.filenameStr = fields[8];
                if ("-".equals(this.filenameStr)) {
                    this.filenameStr = null;
                }
                this.filenameStr = this.fieldParsers.parseString(this.filenameStr, "Filename", false);
            }
            this.archiveLengthStr = fields[fields.length - 1];
            if ("-".equals(this.archiveLengthStr)) {
                this.archiveLengthStr = null;
            }
            this.archiveLength = this.fieldParsers.parseLong(this.archiveLengthStr, "Archive-length", false);
            if (this.archiveLength != null && this.archiveLength < 0L) {
                this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Archive-length' value", new String[]{this.archiveLengthStr, "A non negative number"}));
            }
        }
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void toStringBuilder(StringBuilder sb) {
        if (this.urlStr != null) {
            sb.append("url: ").append(this.urlStr);
        }
        if (this.ipAddressStr != null) {
            sb.append(", ipAddress: ").append(this.ipAddressStr);
        }
        if (this.archiveDateStr != null) {
            sb.append(", archiveDate: ").append(this.archiveDateStr);
        }
        if (this.contentTypeStr != null) {
            sb.append(", contentType: ").append(this.contentTypeStr);
        }
        if (this.resultCodeStr != null) {
            sb.append(", resultCode: ").append(this.resultCodeStr);
        }
        if (this.checksumStr != null) {
            sb.append(", checksum: ").append(this.checksumStr);
        }
        if (this.locationStr != null) {
            sb.append(", location: ").append(this.locationStr);
        }
        if (this.offsetStr != null) {
            sb.append(", offset: ").append(this.offsetStr);
        }
        if (this.filenameStr != null) {
            sb.append(", fileName: ").append(this.filenameStr);
        }
        if (this.archiveLengthStr != null) {
            sb.append(", length: ").append(this.archiveLengthStr);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }
}

