/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import de.schlichtherle.truezip.key.pbe.AesPbeParameters;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipKeyException;
import de.schlichtherle.truezip.zip.ZipParameters;
import de.schlichtherle.truezip.zip.ZipParametersProvider;
import java.net.URI;
import java.nio.charset.Charset;
import javax.annotation.concurrent.ThreadSafe;
import org.bouncycastle.crypto.PBEParametersGenerator;

@ThreadSafe
public class KeyManagerZipCryptoParameters
implements ZipParametersProvider,
ZipCryptoParameters {
    private final ZipDriver driver;
    private final FsModel model;
    protected final Charset charset;

    public KeyManagerZipCryptoParameters(ZipDriver driver, FsModel model, Charset charset) {
        if (null == driver || null == model || null == charset) {
            throw new NullPointerException();
        }
        this.driver = driver;
        this.model = model;
        this.charset = charset;
    }

    @Override
    public <P extends ZipParameters> P get(Class<P> type) {
        if (type.isAssignableFrom(WinZipAesParameters.class)) {
            return (P)((ZipParameters)type.cast(new WinZipAes()));
        }
        return null;
    }

    protected byte[] password(char[] characters, String name) {
        return PBEParametersGenerator.PKCS5PasswordToBytes((char[])characters);
    }

    private <K> KeyManager<K> keyManager(Class<K> type) {
        return this.driver.getKeyManagerProvider().get(type);
    }

    private URI resourceUri(String name) {
        return this.driver.resourceUri(this.model, name);
    }

    private class WinZipAes
    implements WinZipAesParameters {
        final KeyManager<AesPbeParameters> manager;

        private WinZipAes() {
            this.manager = KeyManagerZipCryptoParameters.this.keyManager(AesPbeParameters.class);
        }

        @Override
        public byte[] getWritePassword(String name) throws ZipKeyException {
            KeyProvider<AesPbeParameters> provider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return KeyManagerZipCryptoParameters.this.password(provider.getWriteKey().getPassword(), name);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
        }

        @Override
        public byte[] getReadPassword(String name, boolean invalid) throws ZipKeyException {
            KeyProvider<AesPbeParameters> provider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return KeyManagerZipCryptoParameters.this.password(provider.getReadKey(invalid).getPassword(), name);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
        }

        @Override
        public AesKeyStrength getKeyStrength(String name) throws ZipKeyException {
            KeyProvider<AesPbeParameters> provider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                return (AesKeyStrength)provider.getWriteKey().getKeyStrength();
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
        }

        @Override
        public void setKeyStrength(String name, AesKeyStrength keyStrength) throws ZipKeyException {
            AesPbeParameters param;
            KeyProvider<AesPbeParameters> provider = this.manager.getKeyProvider(KeyManagerZipCryptoParameters.this.resourceUri(name));
            try {
                param = provider.getReadKey(false);
            }
            catch (UnknownKeyException ex) {
                throw new ZipKeyException(ex);
            }
            param.setKeyStrength(keyStrength);
            provider.setKey(param);
        }
    }
}

