/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BPCCBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComponentMapBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ImageHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PaletteBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ROIBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CodestreamHeaderBox
extends JP2Box {
    private Codestream curCodestream;

    public CodestreamHeaderBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        int nch = this._module.getNCodestreamHeaders() + 1;
        this._module.setNCodestreams(nch);
        this.curCodestream = this._module.getCodestream(nch);
        int sizeLeft = (int)this._boxHeader.getDataLength();
        BoxHeader subhdr = new BoxHeader(this._module, this._dstrm);
        int state = 0;
        JP2Box box = null;
        while (this.hasNext()) {
            box = (JP2Box)this.next();
            if (state == 0 && box instanceof LabelBox) {
                state = 1;
                if (!box.readBox()) {
                    return false;
                }
                this.curCodestream.setLabelProperty(new Property("Label", PropertyType.STRING, (Object)((LabelBox)box).getLabel()));
                box = (JP2Box)this.next();
                if (box != null) continue;
                break;
            }
            if (state <= 1) {
                if (box instanceof ImageHeaderBox) {
                    state = 2;
                    if (box.readBox()) continue;
                    return false;
                }
                this._repInfo.setMessage((Message)new ErrorMessage("First box of Codestream Header must be image header", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
            if (box instanceof BPCCBox || box instanceof PaletteBox || box instanceof ComponentMapBox || box instanceof ROIBox) {
                if (box.readBox()) continue;
                return false;
            }
            box.skipBox();
        }
        this.finalizeBytesRead();
        return true;
    }

    protected Codestream getCodestream() {
        return this.curCodestream;
    }

    @Override
    protected String getSelfPropName() {
        return "Codestream Header Box";
    }
}

