/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.ArrayEnd;
import edu.harvard.hul.ois.jhove.module.pdf.ArrayStart;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryEnd;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Literal;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.State;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.StringValuedToken;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import java.util.TreeSet;

public abstract class Tokenizer {
    public static char[] PDFDOCENCODING = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u02d8', '\u02c7', '\u02c6', '\u02d9', '\u02dd', '\u02db', '\u02da', '\u02dc', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2003', '\u2002', '\u0192', '\u2044', '\u2039', '\u203a', '\u2212', '\u2030', '\u201e', '\u201c', '\u201d', '\u2018', '\u2019', '\u201a', '\u2122', '\ufb01', '\ufb02', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\u009f', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ef', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final String EMPTY = "";
    private static final String STREAM = "stream";
    private static final int NUL = 0;
    private static final int HT = 9;
    private static final int LF = 10;
    private static final int FF = 12;
    private static final int CR = 13;
    private static final int[] WHITESPACES = new int[]{0, 9, 10, 12, 13, 32};
    private static final int[] DELIMITERS = new int[]{37, 47, 40, 41, 60, 62, 91, 93, 123, 125};
    protected RandomAccessFile _file;
    protected int _ch = 0;
    private boolean _lookAhead = false;
    private long _offset = 0L;
    private State _state = State.WHITESPACE;
    private String _wsString = "";
    private boolean _pdfACompliant = true;
    private boolean _encrypted;
    private Set<String> _languageCodes = new TreeSet<String>();
    private int _parenLevel;
    private boolean _scanMode = false;

    public Token getNext() throws IOException, PdfException {
        return this.getNext(0L);
    }

    public Token getNext(long max) throws IOException, PdfException {
        Token token = null;
        StringBuilder buffer = null;
        this._state = State.WHITESPACE;
        this._wsString = EMPTY;
        boolean negative = false;
        double realValue = 0.0;
        long intValue = 0L;
        double denom = 10.0;
        long length = 0L;
        int prelastch = 0;
        int lastch = 0;
        boolean sawLineBreak = false;
        boolean sawCR = false;
        long startOffset = this._offset;
        try {
            while (true) {
                if (max > 0L && this._offset - startOffset > max) {
                    if (token != null && token instanceof StringValuedToken && buffer != null) {
                        ((StringValuedToken)token).setValue(buffer.toString());
                    } else {
                        token = null;
                    }
                    return token;
                }
                if (!this._lookAhead) {
                    this._ch = this.readChar();
                    if (this._ch < 0) {
                        this._state = State.WHITESPACE;
                        throw new PdfMalformedException("Unexpected EOF", this._offset);
                    }
                    ++this._offset;
                } else {
                    this._lookAhead = false;
                }
                if (this._state == State.WHITESPACE) {
                    if (Tokenizer.isWhitespace(this._ch)) {
                        this._wsString = this._wsString + (char)this._ch;
                        continue;
                    }
                    if (this._ch == 91) {
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY;
                        return new ArrayStart();
                    }
                    if (this._ch == 93) {
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY;
                        return new ArrayEnd();
                    }
                    if (this._ch == 37) {
                        this._state = State.COMMENT;
                        buffer = new StringBuilder();
                        token = new Comment();
                        continue;
                    }
                    if (this._ch == 43 || this._ch == 45) {
                        this._state = State.NUMERIC;
                        intValue = 0L;
                        negative = this._ch == 45;
                        token = new Numeric();
                        continue;
                    }
                    if (this._ch == 46) {
                        this._state = State.FRACTIONAL;
                        realValue = 0.0;
                        negative = false;
                        denom = 10.0;
                        token = new Numeric();
                        continue;
                    }
                    if (Tokenizer.isNumeral(this._ch)) {
                        this._state = State.NUMERIC;
                        intValue = this._ch - 48;
                        denom = 10.0;
                        token = new Numeric();
                        continue;
                    }
                    if (this._ch == 47) {
                        this._state = State.NAME;
                        buffer = new StringBuilder();
                        token = new Name();
                        continue;
                    }
                    if (this._ch == 40) {
                        if (this._scanMode) continue;
                        this._state = State.LITERAL;
                        this._parenLevel = 0;
                        token = new Literal();
                        buffer = new StringBuilder();
                        continue;
                    }
                    if (this._ch == 60) {
                        this._state = State.LESS_THAN;
                        continue;
                    }
                    if (this._ch == 62) {
                        this._state = State.GREATER_THAN;
                        continue;
                    }
                    if (Tokenizer.isDelimiter(this._ch)) continue;
                    this._state = State.KEYWORD;
                    buffer = new StringBuilder();
                    buffer.append((char)this._ch);
                    token = new Keyword();
                    continue;
                }
                if (this._state == State.COMMENT) {
                    if (this._ch == 13 || this._ch == 10) {
                        this._state = State.WHITESPACE;
                        this._wsString = this._wsString + (char)this._ch;
                        ((StringValuedToken)token).setValue(buffer.toString());
                        if (!token.isPdfACompliant()) {
                            this._pdfACompliant = false;
                        }
                        return token;
                    }
                    buffer.append((char)this._ch);
                    continue;
                }
                if (this._state == State.FRACTIONAL) {
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY + (char)this._ch;
                        if (negative) {
                            realValue = -realValue;
                        }
                        ((Numeric)token).setValue(realValue);
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                        }
                        if (!token.isPdfACompliant()) {
                            this._pdfACompliant = false;
                        }
                        return token;
                    }
                    if (Tokenizer.isNumeral(this._ch)) {
                        realValue += (double)(this._ch - 48) / denom;
                        denom *= 10.0;
                        continue;
                    }
                    this._state = State.WHITESPACE;
                    this._wsString = EMPTY;
                    throw new PdfMalformedException("Lexical error", this._offset);
                }
                if (this._state == State.GREATER_THAN) {
                    if (this._ch == 62) {
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY;
                        return new DictionaryEnd();
                    }
                    this._state = State.WHITESPACE;
                    this._wsString = EMPTY;
                    throw new PdfMalformedException("Lexical error", this._offset);
                }
                if (this._state == State.HEXADECIMAL) {
                    if (this._ch == 62) {
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY;
                        ((Literal)token).convertHex();
                        return token;
                    }
                    if (Tokenizer.isWhitespace(this._ch)) continue;
                    ((Literal)token).appendHex(this._ch);
                    continue;
                }
                if (this._state == State.KEYWORD) {
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                        }
                        if (STREAM.equals(buffer.toString())) {
                            this._state = State.STREAM;
                            sawLineBreak = this._ch == 10;
                            sawCR = this._ch == 13;
                            token = new Stream();
                            length = 0L;
                            lastch = 0;
                            prelastch = 0;
                            this.initStream((Stream)token);
                            continue;
                        }
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY + (char)this._ch;
                        ((StringValuedToken)token).setValue(buffer.toString());
                        if (!token.isPdfACompliant()) {
                            this._pdfACompliant = false;
                        }
                        return token;
                    }
                    buffer.append((char)this._ch);
                    continue;
                }
                if (this._state == State.LESS_THAN) {
                    if (this._ch == 60 || this._scanMode) {
                        this._state = State.WHITESPACE;
                        this._wsString = EMPTY;
                        return new DictionaryStart();
                    }
                    this._state = State.HEXADECIMAL;
                    token = new Literal();
                    buffer = new StringBuilder();
                    if (this._ch == 62) {
                        this.backupChar();
                        continue;
                    }
                    ((Literal)token).appendHex(this._ch);
                    continue;
                }
                if (this._state == State.LITERAL) {
                    this.backupChar();
                    this._offset += ((Literal)token).processLiteral(this) - 1L;
                    this._state = State.WHITESPACE;
                    this._wsString = EMPTY;
                    return token;
                }
                if (this._state == State.NAME) {
                    if (this._ch == 35) {
                        int ch1 = this.readChar();
                        int ch2 = this.readChar();
                        this._ch = (Tokenizer.hexValue(ch1) << 4) + Tokenizer.hexValue(ch2);
                    } else if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                        this._state = State.WHITESPACE;
                        ((StringValuedToken)token).setValue(buffer.toString());
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                            this._wsString = EMPTY;
                        } else {
                            this._wsString = EMPTY + (char)this._ch;
                        }
                        if (!token.isPdfACompliant()) {
                            this._pdfACompliant = false;
                        }
                        return token;
                    }
                    buffer.append((char)this._ch);
                    continue;
                }
                if (this._state == State.NUMERIC) {
                    if (this._ch == 46) {
                        this._state = State.FRACTIONAL;
                        realValue = intValue;
                        denom = 10.0;
                        continue;
                    }
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch) || !Tokenizer.isNumeral(this._ch)) {
                        if (negative) {
                            if (this._state == State.FRACTIONAL) {
                                realValue = -realValue;
                            } else {
                                intValue = -intValue;
                            }
                        }
                        if (this._state == State.FRACTIONAL) {
                            ((Numeric)token).setValue(realValue);
                        } else {
                            ((Numeric)token).setValue(intValue);
                        }
                        this._state = State.WHITESPACE;
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                            this._wsString = EMPTY;
                        } else {
                            this._wsString = EMPTY + (char)this._ch;
                        }
                        if (!token.isPdfACompliant()) {
                            this._pdfACompliant = false;
                        }
                        return token;
                    }
                    if (this._state == State.FRACTIONAL) {
                        realValue = realValue * 10.0 + (double)this._ch - 48.0;
                        continue;
                    }
                    intValue = intValue * 10L + (long)this._ch - 48L;
                    continue;
                }
                if (this._state == State.STREAM) {
                    if (this._ch == 101) {
                        this._state = State.E;
                        continue;
                    }
                    prelastch = lastch;
                    lastch = this._ch;
                    this.setStreamOffset((Stream)token);
                    if (length == 0L && !sawLineBreak) {
                        if (this._ch == 10) {
                            sawLineBreak = true;
                            if (!sawCR) {
                                this._pdfACompliant = false;
                            }
                            ((Stream)token).setOffset(((Stream)token).getOffset() + 1L);
                            continue;
                        }
                        if (this._ch == 13) {
                            sawCR = true;
                            ((Stream)token).setOffset(((Stream)token).getOffset() + 1L);
                            continue;
                        }
                        this._pdfACompliant = false;
                        continue;
                    }
                    ++length;
                    continue;
                }
                if (this._state == State.E) {
                    if (this._ch == 110) {
                        this._state = State.EN;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 2L;
                    continue;
                }
                if (this._state == State.EN) {
                    if (this._ch == 100) {
                        this._state = State.END;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 3L;
                    continue;
                }
                if (this._state == State.END) {
                    if (this._ch == 115) {
                        this._state = State.ENDS;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 4L;
                    continue;
                }
                if (this._state == State.ENDS) {
                    if (this._ch == 116) {
                        this._state = State.ENDST;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 5L;
                    continue;
                }
                if (this._state == State.ENDST) {
                    if (this._ch == 114) {
                        this._state = State.ENDSTR;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 6L;
                    continue;
                }
                if (this._state == State.ENDSTR) {
                    if (this._ch == 101) {
                        this._state = State.ENDSTRE;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 7L;
                    continue;
                }
                if (this._state == State.ENDSTRE) {
                    if (this._ch == 97) {
                        this._state = State.ENDSTREA;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 8L;
                    continue;
                }
                if (this._state == State.ENDSTREA) {
                    if (this._ch == 109) {
                        this._state = State.ENDSTREAM;
                        continue;
                    }
                    this._state = State.STREAM;
                    length += 9L;
                    continue;
                }
                if (this._state != State.ENDSTREAM) continue;
                if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                    this._state = State.WHITESPACE;
                    if (prelastch == 13 && lastch == 10) {
                        length -= 2L;
                    } else if (lastch == 10 || lastch == 13) {
                        --length;
                    }
                    ((Stream)token).setLength(length);
                    if (Tokenizer.isDelimiter(this._ch)) {
                        this._lookAhead = true;
                        this._wsString = EMPTY;
                    } else {
                        this._wsString = EMPTY + (char)this._ch;
                    }
                    return token;
                }
                this._state = State.STREAM;
            }
        }
        catch (EOFException eofe) {
            if (token != null && token instanceof StringValuedToken && buffer != null) {
                ((StringValuedToken)token).setValue(buffer.toString());
            } else {
                token = null;
            }
            return token;
        }
    }

    public long getOffset() {
        return this._offset;
    }

    public Set<String> getLanguageCodes() {
        return this._languageCodes;
    }

    public void setEncrypted(boolean encrypted) {
        this._encrypted = encrypted;
    }

    public boolean getPDFACompliant() {
        return this._pdfACompliant;
    }

    public void setPDFACompliant(boolean pdfACompliant) {
        this._pdfACompliant = pdfACompliant;
    }

    public String getWSString() {
        return this._wsString;
    }

    public abstract void seek(long var1) throws IOException, PdfException;

    protected void seekReset(long offset) {
        this._state = State.WHITESPACE;
        this._wsString = EMPTY;
        this._lookAhead = false;
        this._ch = 0;
        this._offset = offset - 1L;
    }

    public abstract int readChar() throws IOException;

    public int readChar1(boolean utf16) throws IOException {
        if (utf16) {
            int ch1 = this.readChar();
            int ch2 = this.readChar();
            return ch1 << 8 | ch2;
        }
        return this.readChar();
    }

    public abstract void backupChar();

    public void addLanguageCode(String langCode) {
        this._languageCodes.add(langCode);
    }

    private static int hexValue(int h) throws PdfException {
        int d;
        if (Tokenizer.isNumeral(h)) {
            d = h - 48;
        } else if (65 <= h && h <= 70) {
            d = h - 55;
        } else if (97 <= h && h <= 102) {
            d = h - 87;
        } else {
            throw new PdfMalformedException("Invalid character in hex string");
        }
        return d;
    }

    private static boolean isDelimiter(int ch) {
        for (int delimiter : DELIMITERS) {
            if (ch != delimiter) continue;
            return true;
        }
        return false;
    }

    private static boolean isNumeral(int ch) {
        return 48 <= ch && ch <= 57;
    }

    private static boolean isWhitespace(int ch) {
        for (int whitespace : WHITESPACES) {
            if (ch != whitespace) continue;
            return true;
        }
        return false;
    }

    public void scanMode(boolean flag) {
        this._scanMode = flag;
    }

    protected abstract void initStream(Stream var1) throws IOException, PdfException;

    protected abstract void setStreamOffset(Stream var1) throws IOException, PdfException;
}

