/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class GlobalParametersIFD
extends IFD {
    private int _profileType = -1;
    private int _faxProfile = -1;
    private int _codingMethods = -1;
    private String _versionYear = null;
    private int _modeNumber = -1;
    public static final int PROFILETYPE = 401;
    public static final int FAXPROFILE = 402;
    public static final int CODINGMETHODS = 403;
    public static final int VERSIONYEAR = 404;
    public static final int MODENUMBER = 405;
    private static final String[] PROFILETYPE_L = new String[]{"Unspecified", "Group 3 Fax"};
    private static final String[] FAXPROFILE_L = new String[]{"does not conform to a profile defined for TIFF for facsimile", "Minimal black & white lossless, Profile S", "Extended black & white lossless, Profile F", "Lossless JBIG black & white, Profile J", "Lossy color and grayscale, Profile C", "Lossless color and grayscale, Profile L", "Mixed Raster Content, Profile M"};
    private static final String[] CODINGMETHODS_L = new String[]{"unspecified compression", "1-dimensional coding, ITU-T Rec. T.4 (MH - Modified Huffman)", "2-dimensional coding, ITU-T Rec. T.4 (MR - Modified Read)", "2-dimensional coding, ITU-T Rec. T.6 (MMR - Modified MR)", "ITU-T Rec. T.82 coding, using ITU-T Rec. T.85 (JBIG)", "ITU-T Rec. T.81 (Baseline JPEG)", "ITU-T Rec. T.82 coding, using ITU-T Rec. T.43 (JBIG color)"};

    public GlobalParametersIFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        super(offset, info, raf, bigEndian);
    }

    @Override
    public Property getProperty(boolean rawOutput) throws TiffException {
        LinkedList<Property> entries = new LinkedList<Property>();
        if (this._profileType != -1) {
            entries.add(this.addIntegerProperty("ProfileType", this._profileType, PROFILETYPE_L, rawOutput));
        }
        if (this._faxProfile != -1) {
            entries.add(this.addIntegerProperty("FaxProfile", this._faxProfile, FAXPROFILE_L, rawOutput));
        }
        if (this._codingMethods != -1) {
            entries.add(this.addBitmaskProperty("CodingMethods", this._codingMethods, CODINGMETHODS_L, rawOutput));
        }
        if (this._versionYear != null) {
            entries.add(new Property("VersionYear", PropertyType.STRING, (Object)this._versionYear));
        }
        if (this._modeNumber != -1) {
            entries.add(new Property("ModeNumber", PropertyType.INTEGER, (Object)new Integer(this._modeNumber)));
        }
        return this.propertyHeader("GlobalParameterIFD", entries);
    }

    @Override
    public void lookupTag(int tag, int type, long count, long value) throws TiffException {
        try {
            if (tag == 401) {
                GlobalParametersIFD.checkType(tag, type, 4);
                GlobalParametersIFD.checkCount(tag, count, 1);
                this._profileType = (int)this.readLong(type, count, value);
            } else if (tag == 402) {
                GlobalParametersIFD.checkType(tag, type, 1);
                GlobalParametersIFD.checkCount(tag, count, 1);
                this._faxProfile = this.readByte(type, count, value);
            } else if (tag == 403) {
                GlobalParametersIFD.checkType(tag, type, 4);
                GlobalParametersIFD.checkCount(tag, count, 1);
                this._codingMethods = (int)this.readLong(type, count, value);
            } else if (tag == 404) {
                GlobalParametersIFD.checkType(tag, type, 1);
                GlobalParametersIFD.checkCount(tag, count, 4);
                this._versionYear = this.readASCII(count, value);
            } else if (tag == 405) {
                GlobalParametersIFD.checkType(tag, type, 1);
                GlobalParametersIFD.checkCount(tag, count, 1);
                this._modeNumber = this.readByte(type, count, value);
            }
        }
        catch (IOException e) {
            throw new TiffException("Read error for tag " + tag, value);
        }
    }
}

