/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITFP
extends TiffProfileClassIT {
    public TiffProfileClassITFP() {
        this._profileText = "TIFF/IT-FP";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (tifd.getImageDescription() == null) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (!(bps == null || bps.length == 1 && (bps[0] == 4 || bps[0] == 8) || bps.length == 3 && bps[0] == 8 && bps[1] == 8 && bps[2] == 8 || bps.length == 4 && bps[0] == 8 && bps[1] == 8 && bps[2] == 8 && bps[3] == 8)) {
            return false;
        }
        long nsft = tifd.getNewSubfileType();
        if ((nsft & 8L) == 0L) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1, 2, 5})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{3, 4, -1})) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tifd, 1)) {
            return false;
        }
        int pint = niso.getColorSpace();
        int inkSet = tifd.getInkSet();
        int nInks = tifd.getNumberOfInks();
        return pint != 5 || inkSet == 1 && nInks == 4 && this.satisfiesDotRange(tifd, 0, 255);
    }
}

