/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfilePagemaker6
extends TiffProfile {
    public TiffProfilePagemaker6() {
        this._profileText = "Adobe PageMaker 6.0";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        boolean to;
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        long imageLength = niso.getImageLength();
        if (imageLength == -1L || niso.getImageWidth() == -1L) {
            return false;
        }
        boolean so = niso.getStripOffsets() != null;
        boolean bl = to = niso.getTileOffsets() != null;
        if (so && to || !so && !to) {
            return false;
        }
        if (so) {
            if (niso.getStripByteCounts() == null) {
                return false;
            }
            long rowsPerStrip = niso.getRowsPerStrip();
            if (rowsPerStrip == -1L || rowsPerStrip < 1L || rowsPerStrip > imageLength) {
                return false;
            }
        }
        if (to && (niso.getTileWidth() == -1L || niso.getTileLength() == -1L || niso.getTileOffsets() == null || niso.getTileByteCounts() == null)) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 2, 5, 32773, 32895, 32896})) {
            return false;
        }
        int pi = niso.getColorSpace();
        if (pi != 0 && pi != 1 && pi != 2 && pi != 3 && pi != 5 && pi != 8 && pi != 9) {
            return false;
        }
        int inkSet = tifd.getInkSet();
        int spp = niso.getSamplesPerPixel();
        if (pi == 0 || pi == 1 || pi == 3 ? spp != 1 : (pi == 2 || pi == 8 || pi == 9 ? spp != 3 : inkSet == 1 && spp != 4)) {
            return false;
        }
        int[] bps = niso.getBitsPerSample();
        if (bps != null) {
            if (pi == 0 || pi == 1 || pi == 3) {
                for (int i = 0; i < bps.length; ++i) {
                    if (bps[i] == 1 || bps[i] == 2 || bps[i] == 4 || bps[i] == 8) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < bps.length; ++i) {
                    if (bps[i] == 8) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return inkSet != 2 || tifd.getInkNames() != null && tifd.getNumberOfInks() != -1;
    }
}

