/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class RuntimeConfig {
    public static final String DROID_USER = "droidUserDir";
    public static final String DROID_TEMP_DIR = "droidTempDir";
    public static final String LOG_DIR = "droidLogDir";
    public static final String DEFAULT_LOGFOLDER_NAME = "logs";
    public static final String DEFAULT_DROIDFOLDER_NAME = ".droid6";
    private static final String LOG4J2_PROPERTIES = "log4j2.properties";
    private static final String CONSOLE_LOG_THRESHOLD = "consoleLogThreshold";
    private static final String LOG4J2_CONFIGURATION_FILE = "log4j.configurationFile";
    private static final String ERROR_CREATING_LOG4J2_FILE = "Could not create the default log4j2 property file [%s] at: %s";

    private RuntimeConfig() {
    }

    public static void configureRuntimeEnvironment() {
        Path logConfigFile;
        Path logDir;
        Path droidWorkDir;
        Path defaultDroidWorkingFolder = Paths.get(System.getProperty("user.home"), DEFAULT_DROIDFOLDER_NAME);
        try {
            droidWorkDir = RuntimeConfig.createFolderAndSystemProperty(DROID_USER, defaultDroidWorkingFolder);
            Path droidTempDir = RuntimeConfig.createFolderAndSystemProperty(DROID_TEMP_DIR, defaultDroidWorkingFolder);
            Path defaultDroidLogFolder = droidWorkDir.resolve(DEFAULT_LOGFOLDER_NAME);
            logDir = RuntimeConfig.createFolderAndSystemProperty(LOG_DIR, defaultDroidLogFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path logFile = logDir.resolve("droid.log");
        System.setProperty("logFile", logFile.toAbsolutePath().toString());
        String logConfig = RuntimeConfig.getSystemOrEnvironmentProperty(LOG4J2_CONFIGURATION_FILE);
        if (logConfig == null) {
            try {
                logConfigFile = RuntimeConfig.createResourceFile(droidWorkDir, LOG4J2_PROPERTIES, LOG4J2_PROPERTIES);
                String logFileURI = logConfigFile.toUri().toString();
                System.setProperty(LOG4J2_CONFIGURATION_FILE, logFileURI);
            }
            catch (Exception e) {
                String message = String.format(ERROR_CREATING_LOG4J2_FILE, LOG4J2_PROPERTIES, droidWorkDir.toAbsolutePath().toString());
                throw new RuntimeException(message, e);
            }
        } else {
            logConfigFile = Paths.get(URI.create(logConfig));
            String logFileURI = logConfigFile.toUri().toString();
            System.setProperty(LOG4J2_CONFIGURATION_FILE, logFileURI);
        }
        String consoleLogThreshold = RuntimeConfig.getSystemOrEnvironmentProperty(CONSOLE_LOG_THRESHOLD);
        if (consoleLogThreshold == null || consoleLogThreshold.isEmpty()) {
            System.setProperty(CONSOLE_LOG_THRESHOLD, "INFO");
        }
    }

    private static Path createFolderAndSystemProperty(String property, Path defaultFolder) throws IOException {
        String folderPath = RuntimeConfig.getSystemOrEnvironmentProperty(property);
        Path folder = folderPath == null || folderPath.isEmpty() ? defaultFolder : Paths.get(folderPath, new String[0]);
        Files.createDirectories(folder, new FileAttribute[0]);
        System.setProperty(property, folder.toAbsolutePath().toString());
        return folder;
    }

    private static String getSystemOrEnvironmentProperty(String property) {
        String value = System.getProperty(property);
        if (value == null) {
            value = System.getenv(property);
        }
        return value;
    }

    private static Path createResourceFile(Path resourceDir, String fileName, String resourceName) throws IOException {
        try (InputStream in = RuntimeConfig.class.getClassLoader().getResourceAsStream(resourceName);){
            Path resourceFile = resourceDir.resolve(fileName);
            if (!Files.exists(resourceFile, new LinkOption[0])) {
                Files.copy(in, resourceFile, new CopyOption[0]);
            }
            Path path = resourceFile;
            return path;
        }
    }
}

