/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class ArcDateParser {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final ThreadLocal<ArcDateParser> DateParserTL = new ThreadLocal<ArcDateParser>(){

        @Override
        public ArcDateParser initialValue() {
            return new ArcDateParser();
        }
    };

    private ArcDateParser() {
        this.dateFormat.setLenient(false);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private Date parseDate(String dateStr) {
        Date date = null;
        try {
            if (dateStr != null && dateStr.length() == "yyyyMMddHHmmss".length()) {
                date = this.dateFormat.parse(dateStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date getDate(String dateStr) {
        Date date = DateParserTL.get().parseDate(dateStr);
        boolean isValid = date == null ? false : date.getTime() > 0L;
        return isValid ? date : null;
    }

    public static DateFormat getDateFormat() {
        return ArcDateParser.DateParserTL.get().dateFormat;
    }
}

