/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.Collections;
import java.util.List;
import org.apache.fop.area.Block;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;

public class WrapperLayoutManager
extends LeafNodeLayoutManager {
    public WrapperLayoutManager(Wrapper node) {
        super(node);
    }

    @Override
    public InlineArea get(LayoutContext context) {
        InlineArea area = new InlineArea();
        if (this.fobj.hasId()) {
            TraitSetter.setProducerID(area, this.fobj.getId());
        }
        return area;
    }

    @Override
    public void addAreas(PositionIterator posIter, LayoutContext context) {
        if (this.fobj.hasId()) {
            this.addId();
            if (this.parentLayoutManager instanceof BlockStackingLayoutManager && !(this.parentLayoutManager instanceof BlockLayoutManager)) {
                Block helperBlock = new Block();
                helperBlock.setChangeBarList(this.getChangeBarList());
                TraitSetter.setProducerID(helperBlock, this.fobj.getId());
                this.parentLayoutManager.addChildArea(helperBlock);
            } else {
                InlineArea area = this.getEffectiveArea(context);
                area.setChangeBarList(this.getChangeBarList());
                this.parentLayoutManager.addChildArea(area);
            }
        }
        while (posIter.hasNext()) {
            posIter.next();
        }
    }

    @Override
    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }

    @Override
    public List<KnuthSequence> getNextKnuthElements(LayoutContext context, int alignment) {
        List<KnuthSequence> list = super.getNextKnuthElements(context, alignment);
        if (this.parentLayoutManager instanceof LineLayoutManager && !this.fobj.hasId() && this.fobj.hasChildren()) {
            return Collections.emptyList();
        }
        return list;
    }
}

