/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryExtension;
import org.apache.fop.render.pdf.extensions.PDFCollectionExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryType;
import org.apache.fop.render.pdf.extensions.PDFObjectType;

public class PDFDictionaryExtension
extends PDFCollectionExtension {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_PAGE_NUMBERS = "page-numbers";
    private static final long serialVersionUID = -1L;
    private PDFDictionaryType dictionaryType;
    private Map<String, String> properties;
    private List<PDFCollectionEntryExtension> entries;
    private ExtensionAttachment extension;

    PDFDictionaryExtension() {
        this(PDFDictionaryType.Dictionary);
    }

    PDFDictionaryExtension(PDFDictionaryType dictionaryType) {
        super(PDFObjectType.Dictionary);
        this.dictionaryType = dictionaryType;
        this.properties = new HashMap<String, String>();
        this.entries = new ArrayList<PDFCollectionEntryExtension>();
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue() {
        return this.getEntries();
    }

    public PDFDictionaryType getDictionaryType() {
        return this.dictionaryType;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void addEntry(PDFCollectionEntryExtension entry) {
        if (entry.getKey() == null || entry.getKey().length() == 0) {
            throw new IllegalArgumentException("pdf:dictionary key is empty");
        }
        this.entries.add(entry);
    }

    public List<PDFCollectionEntryExtension> getEntries() {
        return this.entries;
    }

    public void setExtension(ExtensionAttachment entry) {
        this.extension = entry;
    }

    public ExtensionAttachment getExtension() {
        return this.extension;
    }

    public PDFCollectionEntryExtension findEntry(String key) {
        for (PDFCollectionEntryExtension entry : this.entries) {
            String entryKey = entry.getKey();
            if (entryKey == null || !entryKey.equals(key)) continue;
            return entry;
        }
        return null;
    }

    public Object findEntryValue(String key) {
        for (PDFCollectionEntryExtension entry : this.entries) {
            String entryKey = entry.getKey();
            if (entryKey == null || !entryKey.equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public PDFCollectionEntryExtension getLastEntry() {
        if (this.entries.size() > 0) {
            return this.entries.get(this.entries.size() - 1);
        }
        return null;
    }

    public boolean usesIDAttribute() {
        return this.dictionaryType.usesIDAttribute();
    }

    @Override
    public String getElementName() {
        return this.dictionaryType.elementName();
    }
}

