/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.automata;

import java.util.Map;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.utils.factory.DeepCopy;

public class ByteMatcherTransition<T>
implements Transition<T> {
    private final ByteMatcher matcher;
    private final State<T> toState;

    public ByteMatcherTransition(ByteMatcher matcher, State<T> toState) {
        this.matcher = matcher;
        this.toState = toState;
    }

    public ByteMatcherTransition(ByteMatcherTransition<T> other, State<T> toState) {
        this.matcher = other.matcher;
        this.toState = toState;
    }

    @Override
    public final State<T> getStateForByte(byte theByte) {
        return this.matcher.matches(theByte) ? this.toState : null;
    }

    @Override
    public final State<T> getToState() {
        return this.toState;
    }

    @Override
    public byte[] getBytes() {
        return this.matcher.getMatchingBytes();
    }

    @Override
    public Transition<T> newTransition(State<T> newState) {
        return new ByteMatcherTransition<T>(this.matcher, newState);
    }

    @Override
    public ByteMatcherTransition<T> deepCopy(Map<DeepCopy, DeepCopy> oldToNewObjects) {
        ByteMatcherTransition<T> transitionCopy = (ByteMatcherTransition<T>)oldToNewObjects.get(this);
        if (transitionCopy == null) {
            oldToNewObjects.put(this, this);
            State<T> copyState = this.toState.deepCopy(oldToNewObjects);
            transitionCopy = new ByteMatcherTransition<T>(this, copyState);
            oldToNewObjects.put(this, transitionCopy);
        }
        return transitionCopy;
    }

    public final ByteMatcher getMatcher() {
        return this.matcher;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[matcher:" + this.matcher + " to state: " + this.toState + ']';
    }
}

