/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.AbstractByteMatcher;
import net.byteseek.matcher.sequence.ByteSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class OneByteMatcher
extends AbstractByteMatcher {
    private final byte byteToMatch;

    public static OneByteMatcher valueOf(byte value) {
        return NodeCache.values[value & 0xFF];
    }

    public OneByteMatcher(byte byteToMatch) {
        this.byteToMatch = byteToMatch;
    }

    public OneByteMatcher(String hexByte) {
        this.byteToMatch = ByteUtils.byteFromHex(hexByte);
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        return window == null ? false : window.getByte(reader.getWindowOffset(matchPosition)) == this.byteToMatch;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return matchPosition >= 0 && matchPosition < bytes.length && bytes[matchPosition] == this.byteToMatch;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return bytes[matchPosition] == this.byteToMatch;
    }

    @Override
    public boolean matches(byte theByte) {
        return theByte == this.byteToMatch;
    }

    @Override
    public byte[] getMatchingBytes() {
        return new byte[]{this.byteToMatch};
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        return ByteUtils.byteToString(prettyPrint, this.byteToMatch & 0xFF);
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return 1;
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats, "numberOfRepeats");
        if (numberOfRepeats == 1) {
            return this;
        }
        return new ByteSequenceMatcher(this.byteToMatch, numberOfRepeats);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + String.format("%02x", this.byteToMatch & 0xFF) + ']';
    }

    private static final class NodeCache {
        static final OneByteMatcher[] values = new OneByteMatcher[256];

        private NodeCache() {
        }

        static {
            for (int i = 0; i < 256; ++i) {
                NodeCache.values[i] = new OneByteMatcher((byte)(i & 0xFF));
            }
        }
    }
}

