/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveInputStreamIterator;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class TarArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droidCore;
    private IdentificationRequestFactory<InputStream> factory;
    private ResultHandler resultHandler;

    public TarArchiveHandler() {
    }

    public TarArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory<InputStream> factory, ResultHandler resultHandler) {
        this.droidCore = droidCore;
        this.factory = factory;
        this.resultHandler = resultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(IdentificationRequest request) throws IOException {
        try (InputStream tarIn = request.getSourceInputStream();
             final TarArchiveInputStream in = new TarArchiveInputStream(tarIn);){
            Iterable<TarArchiveEntry> iterable = new Iterable<TarArchiveEntry>(){

                @Override
                public Iterator<TarArchiveEntry> iterator() {
                    return new TarArchiveEntryIterator(in);
                }
            };
            TarArchiveWalker walker = new TarArchiveWalker(request.getIdentifier(), (ArchiveInputStream)in);
            walker.walk(iterable);
        }
    }

    final void submit(TarArchiveEntry entry, String entryName, URI parentName, ArchiveInputStream in, ResourceId correlationId, long originatorNodeId) throws IOException {
        long size = entry.getSize();
        Date time = entry.getModTime();
        RequestMetaData metaData = new RequestMetaData(size == -1L ? null : Long.valueOf(size), time == null ? null : Long.valueOf(time.getTime()), entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toTarUri(parentName, entry.getName()));
        identifier.setAncestorId(originatorNodeId);
        identifier.setParentResourceId(correlationId);
        IdentificationRequest<InputStream> request = this.factory.newRequest(metaData, identifier);
        if (this.droidCore.passesIdentificationFilter(request)) {
            request.open((InputStream)in);
            this.droidCore.submit(request);
        }
    }

    private ResourceId submitDirectory(URI parentName, TarArchiveEntry entry, String entryName, ResourceId correlationId) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        long size = entry.getSize();
        Date date = entry.getModTime();
        long time = date == null ? -1L : date.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toTarUri(parentName, entry.getName()));
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return this.resultHandler.handleDirectory(result, correlationId, false);
    }

    public final void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public final void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public final void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    private final class TarArchiveWalker
    extends ArchiveFileWalker<TarArchiveEntry> {
        private final ResourceId parentId;
        private final long originatorNodeId;
        private final URI parentName;
        private final ArchiveInputStream in;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();

        TarArchiveWalker(RequestIdentifier parent, ArchiveInputStream in) {
            this.in = in;
            this.parentId = parent.getResourceId();
            this.parentName = parent.getUri();
            this.originatorNodeId = parent.getAncestorId();
        }

        @Override
        protected void handleEntry(TarArchiveEntry entry) throws IOException {
            String entryName = entry.getName();
            String prefixPath = FilenameUtils.getPath((String)entryName);
            ResourceId correlationId = this.parentId;
            if (!prefixPath.isEmpty() && (correlationId = this.directories.get(prefixPath)) == null) {
                correlationId = this.processAncestorFolders(prefixPath);
            }
            if (!(entryName = FilenameUtils.getName((String)entryName)).isEmpty()) {
                TarArchiveHandler.this.submit(entry, entryName, this.parentName, this.in, correlationId, this.originatorNodeId);
            }
        }

        private ResourceId processAncestorFolders(String path) {
            int pathIndex;
            List<String> paths = ArchiveFileUtils.getAncestorPaths(path);
            ResourceId longestParentId = this.parentId;
            int longestSeenBefore = paths.size();
            ResourceId correlationId = null;
            for (pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
                correlationId = this.directories.get(paths.get(pathIndex));
                if (correlationId == null) continue;
                longestSeenBefore = pathIndex;
                longestParentId = correlationId;
                break;
            }
            for (pathIndex = longestSeenBefore - 1; pathIndex >= 0; --pathIndex) {
                String pathName = paths.get(pathIndex);
                TarArchiveEntry entry = new TarArchiveEntry(pathName);
                String dirName = FilenameUtils.getName((String)pathName.substring(0, pathName.length() - 1));
                longestParentId = TarArchiveHandler.this.submitDirectory(this.parentName, entry, dirName, longestParentId);
                this.directories.put(pathName, longestParentId);
            }
            return longestParentId;
        }
    }

    private static final class TarArchiveEntryIterator
    extends ArchiveInputStreamIterator<TarArchiveEntry, TarArchiveInputStream> {
        TarArchiveEntryIterator(TarArchiveInputStream in) {
            super(in);
        }

        @Override
        protected TarArchiveEntry getNextEntry() throws IOException {
            return ((TarArchiveInputStream)this.getInputStream()).getNextTarEntry();
        }
    }
}

