/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementSetterPostAction;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public abstract class MetadataElementSetterPostActionAddDateInParents
implements MetadataElementSetterPostAction {
    private final boolean isStartDate;

    protected MetadataElementSetterPostActionAddDateInParents(boolean isStartDate) {
        this.isStartDate = isStartDate;
    }

    @Override
    public void execute(String oldValue, String newValue, NodeAbstract context, MetadataElement metadataElement, int index) throws MetadataElementSetterPostActionException {
        String metadataAccessorName = metadataElement.getAccessorName();
        NodeFolder parent = (NodeFolder)context.getParent();
        if (parent == null) {
            return;
        }
        try {
            List<String> parentValues = parent.getAllDynamicMetadataValuesForName(metadataAccessorName);
            if (this.isRemoval(newValue)) {
                if (this.checkSingleValue(parentValues, value -> value.equals(oldValue))) {
                    parent.setDynamicMetadataValueForName(metadataAccessorName, 0, "");
                    this.updateParentWithMostExtremeSibling(metadataAccessorName, parent, context, null);
                }
            } else if (this.isDate(newValue) && (parentValues.isEmpty() || this.checkSingleValue(parentValues, value -> value.isEmpty() || this.isDate((String)value)))) {
                this.updateParentWithMostExtremeSibling(metadataAccessorName, parent, context, newValue);
            }
        }
        catch (Exception ex) {
            throw new MetadataElementSetterPostActionException(ex);
        }
    }

    private boolean isRemoval(String newValue) {
        return newValue == null || newValue.isEmpty();
    }

    private boolean checkSingleValue(List<String> values, Function<String, Boolean> condition) {
        return values.size() == 1 ? condition.apply(values.get(0)) : false;
    }

    private void updateParentWithMostExtremeSibling(String metadataAccessorName, NodeFolder parent, NodeAbstract context, String newValue) throws Exception {
        String extremeValue = this.findMostExtremeSiblingValue(metadataAccessorName, parent, context, newValue);
        if (extremeValue != null) {
            parent.setDynamicMetadataValueForName(metadataAccessorName, 0, extremeValue);
        }
    }

    private String findMostExtremeSiblingValue(String metadataAccessorName, NodeFolder parent, NodeAbstract context, String newValue) throws Exception {
        HashMap<LocalDate, String> siblingDatesValues = new HashMap<LocalDate, String>();
        for (MutableTreeTableNode child : parent.getChildren()) {
            String siblingValue;
            LocalDate siblingDate;
            List<String> siblingValues;
            NodeAbstract aChild = (NodeAbstract)child;
            if (context.equals(aChild) || (siblingValues = aChild.getAllDynamicMetadataValuesForName(metadataAccessorName)).size() != 1 || (siblingDate = this.parseInputValueAsDate(siblingValue = siblingValues.get(0))) == null) continue;
            siblingDatesValues.put(siblingDate, siblingValue);
        }
        if (newValue != null) {
            LocalDate newDate = this.parseInputValueAsDate(newValue);
            siblingDatesValues.put(newDate, newValue);
        }
        if (siblingDatesValues.isEmpty()) {
            return null;
        }
        LocalDate extremeSiblingDate = null;
        for (LocalDate siblingDate : siblingDatesValues.keySet()) {
            if (extremeSiblingDate != null && !this.firstDateIsMoreExtreme(siblingDate, extremeSiblingDate)) continue;
            extremeSiblingDate = siblingDate;
        }
        return (String)siblingDatesValues.get(extremeSiblingDate);
    }

    private boolean firstDateIsMoreExtreme(LocalDate extremeDate, LocalDate date) {
        return this.isStartDate ? extremeDate.isBefore(date) : extremeDate.isAfter(date);
    }

    private boolean isDate(String inputValue) {
        return this.parseInputValueAsDate(inputValue) != null;
    }

    private LocalDate parseInputValueAsDate(String inputValue) {
        int defaultDay;
        int defaultMonth = this.isStartDate ? 1 : 12;
        int n = defaultDay = this.isStartDate ? 1 : 31;
        if (inputValue == null || inputValue.isEmpty()) {
            return null;
        }
        List<DateTimeFormatter> dateTimeFormatters = Arrays.asList(DateTimeFormatter.ofPattern("yyyyMMdd"), DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("d.M.yyyy"), DateTimeFormatter.ofPattern("d.MM.yyyy"), DateTimeFormatter.ofPattern("dd.M.yyyy"), DateTimeFormatter.ofPattern("dd.MM.yyyy"), new DateTimeFormatterBuilder().appendPattern("yyyyMM").parseDefaulting(ChronoField.DAY_OF_MONTH, defaultDay).toFormatter(), new DateTimeFormatterBuilder().appendPattern("yyyy-MM").parseDefaulting(ChronoField.DAY_OF_MONTH, defaultDay).toFormatter(), new DateTimeFormatterBuilder().appendPattern("M.yyyy").parseDefaulting(ChronoField.DAY_OF_MONTH, defaultDay).toFormatter(), new DateTimeFormatterBuilder().appendPattern("MM.yyyy").parseDefaulting(ChronoField.DAY_OF_MONTH, defaultDay).toFormatter(), new DateTimeFormatterBuilder().appendPattern("yyyy").parseDefaulting(ChronoField.MONTH_OF_YEAR, defaultMonth).parseDefaulting(ChronoField.DAY_OF_MONTH, defaultDay).toFormatter());
        for (DateTimeFormatter dateFormat : dateTimeFormatters) {
            try {
                return LocalDate.parse(inputValue, dateFormat);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }
}

