/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class MetadataElementValidatorDate
implements MetadataElementValidator {
    private final DateFormat dateFormat;
    private final Pattern datePattern;
    private final Pattern includePattern;
    private final boolean acceptEmpty;
    private final String i18nErrorKey;

    public MetadataElementValidatorDate() {
        this("yyyy-MM-dd", "\\d{4}-\\d{2}-\\d{2}", "MessageValidatorDateCantConvert");
    }

    public MetadataElementValidatorDate(String dateFormatString, String datePatternString, boolean lenient, String i18nErrorKey) {
        this(dateFormatString, datePatternString, null, lenient, true, i18nErrorKey);
    }

    public MetadataElementValidatorDate(String dateFormatString, String datePatternString, String i18nErrorKey) {
        this(dateFormatString, datePatternString, null, true, true, i18nErrorKey);
    }

    public MetadataElementValidatorDate(String dateFormatString, String datePatternString, String includePatternString, boolean lenient, boolean acceptEmpty, String i18nErrorKey) {
        this.dateFormat = new SimpleDateFormat(dateFormatString);
        this.dateFormat.setLenient(lenient);
        this.datePattern = Pattern.compile(datePatternString);
        this.includePattern = includePatternString != null ? Pattern.compile(includePatternString) : null;
        this.acceptEmpty = acceptEmpty;
        this.i18nErrorKey = i18nErrorKey;
    }

    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (this.acceptEmpty && (value == null || value.isEmpty())) {
            return;
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return;
        }
        if (!this.datePattern.matcher(value).matches()) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)this.i18nErrorKey, (Object[])new Object[]{value}));
        }
        try {
            Date date = this.dateFormat.parse(value);
            if (this.includePattern != null && !value.equals(this.dateFormat.format(date)) && !this.includePattern.matcher(value).matches()) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)this.i18nErrorKey, (Object[])new Object[]{value}));
            }
        }
        catch (ParseException ex) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)this.i18nErrorKey, (Object[])new Object[]{value}));
        }
    }
}

