/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;

public abstract class MetadataElementValidators
implements MetadataElementValidator {
    private final MetadataElementValidator[] validators;
    private final String i18nErrorKey;

    public MetadataElementValidators(MetadataElementValidator[] validators, String i18nErrorKey) {
        this.validators = validators;
        this.i18nErrorKey = i18nErrorKey;
    }

    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        boolean atLeastOneOk = false;
        for (MetadataElementValidator metadataElementValidator : this.validators) {
            try {
                metadataElementValidator.check(value, context, metadataElement);
                atLeastOneOk = true;
            }
            catch (MetadataElementValidatorException metadataElementValidatorException) {
                // empty catch block
            }
        }
        if (!atLeastOneOk) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)this.i18nErrorKey, (Object[])new Object[]{value}));
        }
    }
}

