/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class CommentsChunk
extends Chunk {
    public CommentsChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        int numComments = module.readUnsignedShort(this._dstream);
        this.bytesLeft -= 2L;
        if (numComments == 0) {
            return true;
        }
        ArrayList<Property> comments = new ArrayList<Property>(numComments);
        for (int i = 0; i < numComments; ++i) {
            long timestamp = module.readUnsignedInt(this._dstream);
            Date jTimestamp = module.timestampToDate(timestamp);
            int marker = module.readSignedShort(this._dstream);
            int count = module.readUnsignedShort(this._dstream);
            this.bytesLeft -= 8L;
            byte[] buf = new byte[count];
            ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
            this.bytesLeft -= (long)count;
            for (int j = 0; j < buf.length; ++j) {
                if (buf[j] >= 32 && buf[j] <= 127) continue;
                buf[j] = 32;
            }
            String comment = new String(buf, "ASCII");
            Property[] comAr = new Property[]{new Property("Timestamp", PropertyType.DATE, (Object)jTimestamp), new Property("CommentText", PropertyType.STRING, (Object)comment)};
            comments.add(new Property("Comment", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)comAr));
        }
        module.addAiffProperty(new Property("Comments", PropertyType.PROPERTY, PropertyArity.LIST, comments));
        return true;
    }
}

