/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.CachedImageReference;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ScaledImageReference;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class SmoothScaledImageReference
extends CachedImageReference {
    private static final Logger logger = Logger.getLogger(ScaledImageReference.class.toString());
    private static int maxImageWidth = 7000;
    private static int maxImageHeight = 7000;
    private int width;
    private int height;

    protected SmoothScaledImageReference(ImageStream imageStream, GraphicsState graphicsState, Resources resources, int imageIndex, Page page) {
        super(imageStream, graphicsState, resources, imageIndex, page);
        this.width = imageStream.getWidth();
        this.height = imageStream.getHeight();
        ImagePool imagePool = imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage call() {
        BufferedImage image = null;
        long start = System.nanoTime();
        try {
            if (image == null) {
                image = this.imageStream.getImage(this.graphicsState, this.resources);
                if (this.width > maxImageWidth || this.height > maxImageHeight) {
                    return image;
                }
            }
            if (image != null) {
                int width = image.getWidth();
                int height = image.getHeight();
                double imageScale = 1.0;
                if (this.imageStream.getColourSpace() != null && this.imageStream.getColourSpace() instanceof DeviceGray) {
                    imageScale = width < 50 || height < 50 ? 0.9 : 0.99;
                    if (imageScale != 1.0) {
                        image = (BufferedImage)SmoothScaledImageReference.getTrilinearScaledInstance(image, (int)Math.ceil((double)width * imageScale), (int)Math.ceil((double)height * imageScale));
                    }
                } else {
                    if (!(width < 250 && height < 250 || width >= 500 && height >= 500)) {
                        imageScale = 0.9;
                    } else if (!(width < 500 && height < 500 || width >= 1000 && height >= 1000)) {
                        imageScale = 0.8;
                    } else if (!(width < 1000 && height < 1000 || width >= 1500 && height >= 1500)) {
                        imageScale = 0.7;
                    } else if (!(width < 1500 && height < 1500 || width >= 2000 && height >= 2000)) {
                        imageScale = 0.6;
                    } else if (!(width < 2000 && height < 2000 || width >= 2500 && height >= 2500)) {
                        imageScale = 0.5;
                    } else if (!(width < 2500 && height < 2500 || width >= 3000 && height >= 3000)) {
                        imageScale = 0.4;
                    } else if (width >= 3000 || height >= 3000) {
                        imageScale = 0.3;
                    }
                    if (imageScale != 1.0) {
                        AffineTransform tx = new AffineTransform();
                        tx.scale(imageScale, imageScale);
                        AffineTransformOp op = new AffineTransformOp(tx, 3);
                        BufferedImage sbim = op.filter(image, null);
                        image.flush();
                        image = sbim;
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warning("Error loading image: " + this.imageStream.getPObjectReference() + " " + this.imageStream.toString());
        }
        long end = System.nanoTime();
        this.notifyImagePageEvents(end - start);
        return image;
    }

    private static Image getTrilinearScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        BufferedImage img2;
        int type;
        int iw = img.getWidth();
        int ih = img.getHeight();
        Object hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        int n = type = img.getTransparency() == 1 ? 1 : 2;
        while (iw > targetWidth * 2 || ih > targetHeight * 2) {
            iw = iw > targetWidth * 2 ? iw / 2 : iw;
            ih = ih > targetHeight * 2 ? ih / 2 : ih;
            img = SmoothScaledImageReference.scaleImage(img, type, hint, iw, ih);
        }
        if (iw > targetWidth) {
            int iw2 = iw / 2;
            img2 = SmoothScaledImageReference.scaleImage(img, type, hint, iw2, ih);
            if (iw2 < targetWidth) {
                img = SmoothScaledImageReference.scaleImage(img, type, hint, targetWidth, ih);
                img2 = SmoothScaledImageReference.scaleImage(img2, type, hint, targetWidth, ih);
                SmoothScaledImageReference.interpolate(img2, img, iw - targetWidth, targetWidth - iw2);
            }
            img = img2;
            iw = targetWidth;
        }
        if (ih > targetHeight) {
            int ih2 = ih / 2;
            img2 = SmoothScaledImageReference.scaleImage(img, type, hint, iw, ih2);
            if (ih2 < targetHeight) {
                img = SmoothScaledImageReference.scaleImage(img, type, hint, iw, targetHeight);
                img2 = SmoothScaledImageReference.scaleImage(img2, type, hint, iw, targetHeight);
                SmoothScaledImageReference.interpolate(img2, img, ih - targetHeight, targetHeight - ih2);
            }
            img = img2;
            ih = targetHeight;
        }
        if (iw < targetWidth && ih < targetHeight) {
            img = SmoothScaledImageReference.scaleImage(img, type, hint, targetWidth, targetHeight);
        }
        return img;
    }

    private static void interpolate(BufferedImage img1, BufferedImage img2, int weight1, int weight2) {
        float alpha = weight1;
        Graphics2D g2 = img1.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(3, alpha /= (float)(weight1 + weight2)));
        g2.drawImage((Image)img2, 0, 0, null);
        g2.dispose();
    }

    private static BufferedImage scaleImage(BufferedImage orig, int type, Object hint, int w, int h) {
        BufferedImage tmp = ImageUtility.createTranslucentCompatibleImage(w, h);
        Graphics2D g2 = tmp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        g2.drawImage(orig, 0, 0, w, h, null);
        g2.dispose();
        return tmp;
    }

    static {
        try {
            maxImageWidth = Integer.parseInt(Defs.sysProperty("org.icepdf.core.imageReference.smoothscaled.maxwidth", String.valueOf(maxImageWidth)));
            maxImageHeight = Integer.parseInt(Defs.sysProperty("org.icepdf.core.imageReference.smoothscaled.maxheight", String.valueOf(maxImageHeight)));
        }
        catch (NumberFormatException e) {
            logger.warning("Error reading buffered scale factor");
        }
    }
}

