/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.CroppedRasterImageProducer;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public abstract class JimiRasterImageSupport
implements MutableJimiRasterImage,
ImageProducer {
    private static final int HINTS_UNSET = -1;
    protected boolean error = false;
    protected boolean abort = false;
    protected boolean productionStarted = false;
    protected boolean modified = false;
    protected boolean productionAllowed = false;
    protected boolean finished = false;
    protected boolean newFrameData = false;
    protected ColorModel colorModel;
    protected Hashtable properties = new Hashtable();
    private boolean hasConsumer = false;
    private int width;
    private int height;
    private int state;
    private int DEFAULT_HINTS;
    private int hints = this.DEFAULT_HINTS = 30;
    private MulticastImageConsumer directConsumer = new MulticastImageConsumer();
    private MulticastImageConsumer waitingConsumer = new MulticastImageConsumer();
    private JimiDecodingController decodingController;
    private JimiImageFactory imageFactory = new MemoryJimiImageFactory();
    private FormatOptionSet options = new BasicFormatOptionSet(new FormatOption[0]);
    protected ColorModel sourceColorModel = null;
    protected boolean forceRGB = false;
    protected int[] rowBuf;
    protected boolean waitForOptions;

    protected JimiRasterImageSupport(int n, int n2, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.setColorModel(colorModel);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.hasConsumer = true;
        this.initConsumer(imageConsumer);
        if (!this.productionStarted) {
            this.addDirectConsumer(imageConsumer);
            this.productionStarted = true;
            if (this.decodingController != null) {
                this.decodingController.requestDecoding();
            }
        } else if (this.finished) {
            this.addWaitingConsumer(imageConsumer);
        } else {
            boolean bl = this.catchupConsumer(imageConsumer);
            if (bl) {
                this.addDirectConsumer(imageConsumer);
            } else {
                this.addWaitingConsumer(imageConsumer);
            }
        }
    }

    protected void addDirectConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        this.directConsumer.addConsumer(imageConsumer);
        imageConsumer.setHints(this.hints);
    }

    protected synchronized void addWaitingConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        imageConsumer.setHints(this.DEFAULT_HINTS);
        if (this.finished) {
            try {
                this.sendToConsumerFully(imageConsumer);
                imageConsumer.imageComplete(3);
            }
            catch (ImageAccessException imageAccessException) {
                imageConsumer.imageComplete(1);
            }
        } else {
            this.waitingConsumer.addConsumer(imageConsumer);
        }
    }

    protected synchronized boolean catchupConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    protected ColorModel getAppropriateColorModel(ColorModel colorModel) {
        return colorModel;
    }

    public void getChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        try {
            if (this.rowBuf == null) {
                this.rowBuf = new int[n4];
            }
            int n8 = 0;
            while (n8 < n5) {
                this.getRowRGB(n3 + n8, this.rowBuf, 0);
                int n9 = 0;
                while (n9 < n4) {
                    byArray[n6 + n9 + n8 * n7] = (byte)(this.rowBuf[n9] >>> n);
                    ++n9;
                }
                ++n8;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public synchronized void getChannelRow(int n, int n2, byte[] byArray, int n3) throws ImageAccessException {
        this.getChannelRectangle(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public ImageProducer getCroppedImageProducer(int n, int n2, int n3, int n4) {
        return new CroppedRasterImageProducer(this, n, n2, n3, n4);
    }

    protected MulticastImageConsumer getDirectConsumer() {
        return this.directConsumer;
    }

    public JimiImageFactory getFactory() {
        return this.imageFactory;
    }

    public int getHeight() {
        return this.height;
    }

    public ImageProducer getImageProducer() {
        return this;
    }

    public FormatOptionSet getOptions() {
        if (this.waitForOptions) {
            this.waitFinished();
        }
        return this.options;
    }

    public abstract int getPixelRGB(int var1, int var2) throws ImageAccessException;

    public Hashtable getProperties() {
        return this.properties;
    }

    public synchronized void getRectangleARGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRowRGB(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 24);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 16);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 8);
                byArray[n7 * n6 + n9++ + n5] = (byte)this.rowBuf[n8++];
                ++n10;
            }
            ++n7;
        }
    }

    public abstract void getRectangleRGB(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws ImageAccessException;

    public synchronized void getRectangleRGBAChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRowRGB(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 16);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 8);
                byArray[n7 * n6 + n9++ + n5] = (byte)this.rowBuf[n8];
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8++] >>> 24);
                ++n10;
            }
            ++n7;
        }
    }

    public synchronized void getRectangleRGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRowRGB(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 16);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 8);
                byArray[n7 * n6 + n9++ + n5] = (byte)this.rowBuf[n8++];
                ++n10;
            }
            ++n7;
        }
    }

    public abstract void getRowRGB(int var1, int[] var2, int var3) throws ImageAccessException;

    public int getWidth() {
        return this.width;
    }

    protected boolean hasDirectConsumer() {
        return this.directConsumer.isEmpty() ^ true;
    }

    protected void initConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setColorModel(this.getColorModel());
        imageConsumer.setProperties(this.properties);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.directConsumer.contains(imageConsumer) || this.waitingConsumer.contains(imageConsumer);
    }

    public boolean isError() {
        return this.error;
    }

    public boolean mustWaitForOptions() {
        return this.waitForOptions;
    }

    public synchronized void produceCroppedImage(ImageConsumer imageConsumer, Rectangle rectangle) {
        this.waitFinished();
        this.initConsumer(imageConsumer);
        imageConsumer.setDimensions(rectangle.width, rectangle.height);
        imageConsumer.setHints(this.DEFAULT_HINTS);
        try {
            this.sendRegionToConsumerFully(imageConsumer, rectangle);
            imageConsumer.imageComplete(3);
        }
        catch (Exception exception) {
            imageConsumer.imageComplete(1);
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.directConsumer.removeConsumer(imageConsumer);
        this.waitingConsumer.removeConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.addWaitingConsumer(imageConsumer);
    }

    protected abstract void sendRegionToConsumerFully(ImageConsumer var1, Rectangle var2) throws ImageAccessException;

    protected abstract void sendToConsumerFully(ImageConsumer var1) throws ImageAccessException;

    public void setColorModel(ColorModel colorModel) {
        if (!this.forceRGB) {
            this.colorModel = this.getAppropriateColorModel(colorModel);
            this.forceRGB |= colorModel != this.colorModel;
        }
        this.sourceColorModel = colorModel;
    }

    public synchronized void setDecodingController(JimiDecodingController jimiDecodingController) {
        this.decodingController = jimiDecodingController;
        if (this.hasConsumer || this.productionStarted) {
            jimiDecodingController.requestDecoding();
        }
    }

    public synchronized void setError() {
        this.error = true;
        this.directConsumer.imageComplete(1);
        this.waitingConsumer.imageComplete(1);
        this.notifyAll();
    }

    public void setFactory(JimiImageFactory jimiImageFactory) {
        this.imageFactory = jimiImageFactory;
    }

    public synchronized void setFinished() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.newFrameData = false;
        this.directConsumer.imageComplete(3);
        this.directConsumer.removeAll();
        if (!this.waitingConsumer.isEmpty()) {
            try {
                this.sendToConsumerFully(this.waitingConsumer);
            }
            catch (ImageAccessException imageAccessException) {
                this.setError();
                return;
            }
        }
        ImageConsumer[] imageConsumerArray = this.waitingConsumer.getConsumers();
        this.waitingConsumer.imageComplete(3);
        this.waitingConsumer.removeAll();
        this.notifyAll();
    }

    public void setImageConsumerHints(int n) {
        this.hints = n |= 0x10;
    }

    protected void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.directConsumer.setHints(this.hints);
            this.productionStarted = true;
            if (this.decodingController != null) {
                this.decodingController.requestDecoding();
            }
        }
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.options = formatOptionSet;
    }

    public void setWaitForOptions(boolean bl) {
        this.waitForOptions = bl;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.removeConsumer(imageConsumer);
        this.addConsumer(imageConsumer);
    }

    public synchronized void waitFinished() {
        this.productionStarted = true;
        if (this.decodingController != null) {
            this.decodingController.requestDecoding();
        }
        while (!this.finished && !this.error) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitInfoAvailable() {
    }
}

