/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class FatFile
extends AbstractFsObject
implements FsFile {
    private final FatDirectoryEntry entry;
    private final ClusterChain chain;

    private FatFile(FatDirectoryEntry myEntry, ClusterChain chain) {
        super(myEntry.isReadOnly());
        this.entry = myEntry;
        this.chain = chain;
    }

    static FatFile get(Fat fat, FatDirectoryEntry entry) throws IOException {
        if (entry.isDirectory()) {
            throw new IllegalArgumentException(entry + " is a directory");
        }
        ClusterChain cc = new ClusterChain(fat, entry.getStartCluster(), entry.isReadonlyFlag());
        if (entry.getLength() > cc.getLengthOnDisk()) {
            throw new IOException("entry (" + entry.getLength() + ") is larger than associated cluster chain (" + cc.getLengthOnDisk() + ")");
        }
        return new FatFile(entry, cc);
    }

    @Override
    public long getLength() {
        this.checkValid();
        return this.entry.getLength();
    }

    @Override
    public void setLength(long length) throws ReadOnlyException, IOException {
        this.checkWritable();
        if (this.getLength() == length) {
            return;
        }
        this.updateTimeStamps(true);
        this.chain.setSize(length);
        this.entry.setStartCluster(this.chain.getStartCluster());
        this.entry.setLength(length);
    }

    @Override
    public void read(long offset, ByteBuffer dest) throws IOException {
        this.checkValid();
        int len = dest.remaining();
        if (len == 0) {
            return;
        }
        if (offset + (long)len > this.getLength()) {
            throw new EOFException();
        }
        if (!this.isReadOnly()) {
            this.updateTimeStamps(false);
        }
        this.chain.readData(offset, dest);
    }

    @Override
    public void write(long offset, ByteBuffer srcBuf) throws ReadOnlyException, IOException {
        this.checkWritable();
        this.updateTimeStamps(true);
        long lastByte = offset + (long)srcBuf.remaining();
        if (lastByte > this.getLength()) {
            this.setLength(lastByte);
        }
        this.chain.writeData(offset, srcBuf);
    }

    private void updateTimeStamps(boolean write) {
        long now = System.currentTimeMillis();
        this.entry.setLastAccessed(now);
        if (write) {
            this.entry.setLastModified(now);
        }
    }

    @Override
    public void flush() throws ReadOnlyException {
        this.checkWritable();
    }

    ClusterChain getChain() {
        this.checkValid();
        return this.chain;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [length=" + this.getLength() + ", first cluster=" + this.chain.getStartCluster() + "]";
    }
}

