/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.resources.SevenZResource;
import org.apache.ant.compress.util.SevenZStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileProvider;

public class SevenZScanner
extends CommonsCompressArchiveScanner {
    public SevenZScanner() {
        this(false, null);
    }

    public SevenZScanner(boolean skipUnreadable, Project project) {
        super(new SevenZStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            @Override
            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new SevenZResource(archive, encoding, (SevenZArchiveEntry)entry);
            }
        }, skipUnreadable, project);
    }

    @Override
    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        FileProvider fp = (FileProvider)src.as(FileProvider.class);
        if (fp == null) {
            super.fillMapsFromArchive(src, encoding, fileEntries, matchFileEntries, dirEntries, matchDirEntries);
            return;
        }
        File srcFile = fp.getFile();
        SevenZArchiveEntry entry = null;
        try (SevenZFile zf = new SevenZFile(srcFile);){
            entry = zf.getNextEntry();
            while (entry != null) {
                SevenZResource r = new SevenZResource(srcFile, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = SevenZScanner.trimSeparator((String)name);
                    dirEntries.put(name, r);
                    if (this.match(name)) {
                        matchDirEntries.put(name, r);
                    }
                } else {
                    fileEntries.put(name, r);
                    if (this.match(name)) {
                        matchFileEntries.put(name, r);
                    }
                }
                entry = zf.getNextEntry();
            }
        }
        catch (IOException ex) {
            throw new BuildException("Problem opening " + srcFile, (Throwable)ex);
        }
    }
}

