/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.AbstractReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ByteArrayReadOnlyFile
extends AbstractReadOnlyFile {
    private final byte[] buffer;
    private final int start;
    private int position;
    private int limit;

    @CreatesObligation
    public ByteArrayReadOnlyFile(byte[] buf) {
        this(buf, 0, buf.length);
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayReadOnlyFile(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.position = this.start = offset;
        this.limit = Math.min(offset + length, buffer.length);
    }

    @Override
    public long length() {
        return this.limit - this.start;
    }

    @Override
    public long getFilePointer() {
        return this.position - this.start;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException();
        }
        this.position = (pos += (long)this.start) < (long)this.limit ? (int)pos : this.limit;
    }

    @Override
    public int read() {
        return this.position < this.limit ? this.buffer[this.position++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int remaining) {
        if (remaining <= 0) {
            return 0;
        }
        int position = this.position;
        int available = this.limit - position;
        if (available <= 0) {
            return -1;
        }
        if (remaining > available) {
            remaining = available;
        }
        System.arraycopy(this.buffer, position, buffer, offset, remaining);
        this.position += remaining;
        return remaining;
    }

    @Override
    public void close() throws IOException {
    }
}

