/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;

@CleanupObligation
public abstract class Resource<X extends Exception>
implements AutoCloseable {
    private boolean closed;

    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    @DischargesObligation
    public void close() throws X {
        if (this.closed) {
            return;
        }
        this.onBeforeClose();
        this.closed = true;
        this.onAfterClose();
    }

    protected void onBeforeClose() throws X {
    }

    protected void onAfterClose() throws X {
    }
}

