/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXJ
extends TiffFXBase {
    public TiffProfileFXJ() {
        this._profileText = "TIFF-FX (Profile J)";
        this._mimeClass = 1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesClass(tifd)) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps[0] != 1) {
            return false;
        }
        int cmp = niso.getCompressionScheme();
        if (cmp != 9) {
            return false;
        }
        if (!this.satisfiesFillOrder(tifd, new int[]{1, 2})) {
            return false;
        }
        if (cmp == 4 && tifd.getT6Options() != 0L) {
            return false;
        }
        boolean xywOK = false;
        long xRes = niso.getXSamplingFrequency().toLong();
        long yRes = niso.getYSamplingFrequency().toLong();
        if (niso.getSamplingFrequencyUnit() == 3) {
            xRes = this.perCMtoPerInch((int)xRes);
            yRes = this.perCMtoPerInch((int)yRes);
        }
        long wid = niso.getImageWidth();
        if ((xRes == 200L && yRes == 100L || xRes == 204L && yRes == 98L || xRes == 200L && yRes == 200L || xRes == 204L && yRes == 196L || xRes == 204L && yRes == 391L) && (wid == 1728L || wid == 2048L || wid == 2432L)) {
            xywOK = true;
        }
        if (xRes == 300L && yRes == 300L && (wid == 2592L || wid == 3072L || wid == 3648L)) {
            xywOK = true;
        }
        if ((xRes == 408L && yRes == 391L || xRes == 400L && yRes == 400L) && (wid == 3456L || wid == 4096L || wid == 4864L)) {
            xywOK = true;
        }
        return xywOK;
    }
}

