/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.converter.exceptions.OOConverterShallNotBeUsedException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import javax.swing.SwingWorker;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.ExistingProcessAction;
import org.jodconverter.local.office.LocalOfficeManager;

public class OOConverter {
    private static String Path;
    private static String Host;
    private static Integer Port;
    private static boolean ShallNotBeUsed;
    private static LocalOfficeManager OOManager;
    private static LocalConverter OOConverter;

    public static void main(String ... args) throws IOException, FileUtilExceptionListException, OOConverterShallNotBeUsedException, OfficeException {
        if (args.length != 2) {
            Logger.error((Object)"Wrong number of arguments.");
            Logger.error((Object)"Usage: OOConverter [path/to/]sourceFile [path/to/]destinationFile");
            return;
        }
        ch.docuteam.converter.OOConverter.convert2PDF(args[0], args[1]);
    }

    public static String getConverterPath() {
        return Path;
    }

    public static void setConverterPath(String path) {
        try {
            new File(path).getCanonicalPath();
            Path = path;
        }
        catch (IOException e) {
            Logger.error((Object)("setConverterPath failed: " + e));
        }
    }

    public static boolean shallNotBeUsed() {
        return ShallNotBeUsed;
    }

    public static void initializeDontWait(String ooConverterPath, String ooConverterHost, Integer ooConverterPort) {
        if (ooConverterHost != null && !ooConverterHost.isEmpty()) {
            Host = ooConverterHost;
        }
        if (ooConverterPort != null) {
            Port = ooConverterPort;
        }
        ch.docuteam.converter.OOConverter.initializeDontWait(ooConverterPath);
    }

    public static void initializeDontWait(String ooConverterPath) {
        if (ooConverterPath != null && !ooConverterPath.isEmpty()) {
            Path = FileUtil.asCanonicalFileName((String)ooConverterPath);
        }
        ch.docuteam.converter.OOConverter.initializeDontWait();
    }

    public static void initializeDontWait() {
        new SwingWorker<Integer, Object>(){

            @Override
            public Integer doInBackground() throws OfficeException {
                ch.docuteam.converter.OOConverter.initialize();
                return 0;
            }
        }.execute();
    }

    public static void initialize(String ooConverterPath, String ooConverterHost, Integer ooConverterPort) throws OfficeException {
        if (ooConverterHost != null && !ooConverterHost.isEmpty()) {
            Host = ooConverterHost;
        }
        if (ooConverterPort != null) {
            Port = ooConverterPort;
        }
        ch.docuteam.converter.OOConverter.initialize(ooConverterPath);
    }

    public static void initialize(String ooConverterPath) throws OfficeException {
        if (ooConverterPath != null && !ooConverterPath.isEmpty()) {
            Path = FileUtil.asCanonicalFileName((String)ooConverterPath);
        }
        ch.docuteam.converter.OOConverter.initialize();
    }

    public static void initialize() {
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        if (Port != null) {
            builder.portNumbers(new int[]{Port});
        }
        if (Host != null) {
            builder.hostName(Host);
        }
        if (Path != null) {
            builder.officeHome(Path);
        }
        builder.existingProcessAction(ExistingProcessAction.CONNECT_OR_KILL).keepAliveOnShutdown(Boolean.valueOf(true));
        OOManager = ((LocalOfficeManager.Builder)builder.install()).build();
        try {
            OOManager.start();
        }
        catch (OfficeException e) {
            Logger.warn((Object)String.format("Could not launch the OO manager for converting files (host: '%s', port: '%s', path: '%s')", Host, Port, Path), (Throwable)e);
            ShallNotBeUsed = true;
            return;
        }
        HashMap<String, Comparable<Boolean>> filterData = new HashMap<String, Comparable<Boolean>>();
        filterData.put("ExportFormFields", Boolean.valueOf(false));
        filterData.put("ExportNotes", Boolean.valueOf(true));
        filterData.put("ExportPlaceholders", Boolean.valueOf(false));
        filterData.put("ReduceImageResolution", Boolean.valueOf(false));
        filterData.put("SelectPdfVersion", Integer.valueOf(1));
        filterData.put("UseLosslessCompression", Boolean.valueOf(true));
        HashMap<String, HashMap<String, Comparable<Boolean>>> customProperties = new HashMap<String, HashMap<String, Comparable<Boolean>>>();
        customProperties.put("FilterData", filterData);
        OOConverter = LocalConverter.builder().storeProperties(customProperties).build();
    }

    public static void disconnect() {
        if (OOManager != null) {
            Logger.debug((Object)"Disconnecting OOConverter...");
            try {
                OOManager.stop();
            }
            catch (OfficeException e) {
                Logger.warn((Object)"Could not stop OOConverter!", (Throwable)e);
            }
        }
        Path = null;
        Host = null;
        Port = null;
        OOManager = null;
        OOConverter = null;
        ShallNotBeUsed = false;
    }

    public static void convert2PDF(String sourceFileName, String destinationFileName) throws IOException, FileUtilExceptionListException, OOConverterShallNotBeUsedException, OfficeException {
        File sourceFile;
        ch.docuteam.converter.OOConverter.initializeIfNecessary();
        if (ShallNotBeUsed) {
            throw new OOConverterShallNotBeUsedException();
        }
        Logger.info((Object)("Converting file: '" + sourceFileName + "' to PDF: '" + destinationFileName + "'"));
        File originalSourceFile = sourceFile = new File(sourceFileName);
        File destinationFile = new File(destinationFileName);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFileName);
        }
        FileUtil.createFolderMerging((File)destinationFile.getParentFile());
        FileUtil.delete((File)destinationFile);
        try {
            sourceFile = FileUtil.copySourceFileInTemp((File)sourceFile);
            OOConverter.convert(sourceFile).to(destinationFile).execute();
        }
        catch (OfficeException e) {
            Logger.error((Object)"File conversion failed - maybe the OpenOffice service is not running?");
            throw e;
        }
        finally {
            if (!Files.isSameFile(sourceFile.toPath(), originalSourceFile.toPath())) {
                sourceFile.delete();
            }
        }
    }

    private static void initializeIfNecessary() throws OfficeException {
        if (OOManager == null) {
            ch.docuteam.converter.OOConverter.initialize();
        }
    }

    static {
        Port = 8100;
        ShallNotBeUsed = false;
    }
}

