/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.InputSource;

public abstract class XMPSource
extends InputSource {
    protected Reader _reader;

    public XMPSource(Reader rdr) {
        super(rdr);
        this._reader = rdr;
    }

    public Property makeProperty() throws IOException {
        int ch;
        boolean maybePI = false;
        boolean seenStart = false;
        this.resetReader();
        StringBuffer textBuf = new StringBuffer();
        StringBuffer xpacBuf = new StringBuffer();
        while ((ch = this._reader.read()) >= 0) {
            if (maybePI) {
                xpacBuf.append((char)ch);
                if ("<?xpacket".equals(xpacBuf.toString())) {
                    if (seenStart) break;
                    seenStart = true;
                    xpacBuf.setLength(0);
                    maybePI = false;
                    int prevCh = 0;
                    while ((ch = this._reader.read()) >= 0 && (prevCh != 63 || ch != 62)) {
                        prevCh = ch;
                    }
                }
                if ("<?xpacket".startsWith(xpacBuf.toString())) continue;
                maybePI = false;
                textBuf.append(xpacBuf);
                xpacBuf.setLength(0);
                continue;
            }
            if (ch == 60) {
                maybePI = true;
                xpacBuf.append((char)ch);
                continue;
            }
            textBuf.append((char)ch);
        }
        return new Property("XMP", PropertyType.STRING, textBuf.toString().trim());
    }

    protected abstract void resetReader();
}

