/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class Rotate
extends ImageFilter {
    private double angle;
    private double cos;
    private double sin;
    private Rectangle rotatedSpace;
    private Rectangle originalSpace;
    private ColorModel defaultRGBModel;
    private int[] inPixels;
    private int[] outPixels;

    public Rotate(double d) {
        this.angle = d * (Math.PI / 180);
        this.cos = Math.cos(this.angle);
        this.sin = Math.sin(this.angle);
        this.defaultRGBModel = ColorModel.getRGBdefault();
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        double[] dArray = new double[2];
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = this.rotatedSpace.width;
        int n5 = this.rotatedSpace.height;
        this.outPixels = new int[n4 * n5];
        int n6 = this.rotatedSpace.x;
        int n7 = this.rotatedSpace.y;
        double[] dArray2 = new double[2];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                this.transformBack(n6 + n10, n7 + n9, dArray);
                int n11 = (int)Math.round(dArray[0]);
                int n12 = (int)Math.round(dArray[1]);
                this.outPixels[n8++] = n11 < 0 || n11 >= n2 || n12 < 0 || n12 >= n3 ? 0 : this.inPixels[n12 * n2 + n11];
                ++n10;
            }
            ++n9;
        }
        this.consumer.setPixels(0, 0, n4, n5, this.defaultRGBModel, this.outPixels, 0, n4);
        this.consumer.imageComplete(n);
    }

    public void setColorModel(ColorModel colorModel) {
        this.consumer.setColorModel(this.defaultRGBModel);
    }

    public void setDimensions(int n, int n2) {
        this.originalSpace = new Rectangle(0, 0, n, n2);
        this.rotatedSpace = new Rectangle(0, 0, n, n2);
        this.transformSpace(this.rotatedSpace);
        this.inPixels = new int[this.originalSpace.width * this.originalSpace.height];
        this.consumer.setDimensions(this.rotatedSpace.width, this.rotatedSpace.height);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n2 * this.originalSpace.width + n;
        int n8 = n5;
        int n9 = n6 - n3;
        int n10 = this.originalSpace.width - n3;
        int n11 = 0;
        while (n11 < n4) {
            int n12 = 0;
            while (n12 < n3) {
                this.inPixels[n7++] = colorModel.getRGB(byArray[n8++] & 0xFF);
                ++n12;
            }
            n8 += n9;
            n7 += n10;
            ++n11;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2 * this.originalSpace.width + n;
        int n8 = n5;
        int n9 = n6 - n3;
        int n10 = this.originalSpace.width - n3;
        int n11 = 0;
        while (n11 < n4) {
            int n12 = 0;
            while (n12 < n3) {
                this.inPixels[n7++] = colorModel.getRGB(nArray[n8++]);
                ++n12;
            }
            n8 += n9;
            n7 += n10;
            ++n11;
        }
    }

    private void transform(int n, int n2, double[] dArray) {
        dArray[0] = (double)n * this.cos + (double)n2 * this.sin;
        dArray[1] = (double)n2 * this.cos - (double)n * this.sin;
    }

    private void transformBack(int n, int n2, double[] dArray) {
        dArray[0] = (double)n * this.cos - (double)n2 * this.sin;
        dArray[1] = (double)n2 * this.cos + (double)n * this.sin;
    }

    public void transformSpace(Rectangle rectangle) {
        double[] dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = 0;
        while (n5 < 4) {
            switch (n5) {
                case 0: {
                    this.transform(n3, n4, dArray);
                    break;
                }
                case 1: {
                    this.transform(n3 + n, n4, dArray);
                    break;
                }
                case 2: {
                    this.transform(n3, n4 + n2, dArray);
                    break;
                }
                case 3: {
                    this.transform(n3 + n, n4 + n2, dArray);
                    break;
                }
            }
            d = Math.min(d, dArray[0]);
            d2 = Math.min(d2, dArray[1]);
            d3 = Math.max(d3, dArray[0]);
            d4 = Math.max(d4, dArray[1]);
            ++n5;
        }
        rectangle.x = (int)Math.floor(d);
        rectangle.y = (int)Math.floor(d2);
        rectangle.width = (int)Math.ceil(d3) - rectangle.x;
        rectangle.height = (int)Math.ceil(d4) - rectangle.y;
    }
}

