/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.DigitalSignatureFactory;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.util.Defs;

public class SignatureHandler {
    private static final Logger logger = Logger.getLogger(SignatureHandler.class.toString());

    public SignatureValidator validateSignature(SignatureFieldDictionary signatureFieldDictionary) {
        SignatureDictionary signatureDictionary = signatureFieldDictionary.getSignatureDictionary();
        if (signatureDictionary != null) {
            try {
                SignatureValidator signatureValidator = DigitalSignatureFactory.getInstance().getValidatorInstance(signatureFieldDictionary);
                return signatureValidator;
            }
            catch (SignatureIntegrityException e) {
                logger.log(Level.WARNING, "Signature certificate could not be initialized.", e);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Signature validation was unsuccessful.", e);
            }
        }
        return null;
    }

    static {
        String defaultSecurityProvider = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        String customSecurityProvider = Defs.sysProperty("org.icepdf.core.security.jceProvider");
        if (customSecurityProvider != null) {
            defaultSecurityProvider = customSecurityProvider;
        }
        try {
            Object provider = Class.forName(defaultSecurityProvider).newInstance();
            Security.insertProviderAt((Provider)provider, 2);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Optional BouncyCastle security provider not found");
        }
        catch (InstantiationException e) {
            logger.log(Level.FINE, "Optional BouncyCastle security provider could not be instantiated");
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, "Optional BouncyCastle security provider could not be created");
        }
    }
}

