/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.io.IOException;
import java.io.OutputStream;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.write.biff.CompoundFile;
import jxl.write.biff.ExcelDataOutput;
import jxl.write.biff.FileDataOutput;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MemoryDataOutput;

public final class File {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$File == null ? (class$jxl$write$biff$File = File.class$("jxl.write.biff.File")) : class$jxl$write$biff$File);
    private ExcelDataOutput data;
    private int pos;
    private OutputStream outputStream;
    private int initialFileSize;
    private int arrayGrowSize;
    private WorkbookSettings workbookSettings;
    jxl.read.biff.CompoundFile readCompoundFile;
    static /* synthetic */ Class class$jxl$write$biff$File;

    File(OutputStream os, WorkbookSettings ws, jxl.read.biff.CompoundFile rcf) throws IOException {
        this.outputStream = os;
        this.workbookSettings = ws;
        this.readCompoundFile = rcf;
        this.createDataOutput();
    }

    private void createDataOutput() throws IOException {
        if (this.workbookSettings.getUseTemporaryFileDuringWrite()) {
            this.data = new FileDataOutput(this.workbookSettings.getTemporaryFileDuringWriteDirectory());
        } else {
            this.initialFileSize = this.workbookSettings.getInitialFileSize();
            this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
            this.data = new MemoryDataOutput(this.initialFileSize, this.arrayGrowSize);
        }
    }

    void close(boolean cs) throws IOException, JxlWriteException {
        CompoundFile cf = new CompoundFile(this.data, this.data.getPosition(), this.outputStream, this.readCompoundFile);
        cf.write();
        this.outputStream.flush();
        this.data.close();
        if (cs) {
            this.outputStream.close();
        }
        this.data = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public void write(ByteData record) throws IOException {
        byte[] bytes = record.getBytes();
        this.data.write(bytes);
    }

    int getPos() throws IOException {
        return this.data.getPosition();
    }

    void setData(byte[] newdata, int pos) throws IOException {
        this.data.setData(newdata, pos);
    }

    public void setOutputFile(OutputStream os) throws IOException {
        if (this.data != null) {
            logger.warn("Rewriting a workbook with non-empty data");
        }
        this.outputStream = os;
        this.createDataOutput();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

