/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class LimitedSizeIteratorUtil {
    public static Set<BindingSet> addAll(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, Set<BindingSet> includeSet, AtomicLong used, long maxSize) throws QueryEvaluationException {
        while (arg2.hasNext()) {
            if (!includeSet.add((BindingSet)arg2.next()) || used.incrementAndGet() <= maxSize) continue;
            throw new QueryEvaluationException("Size limited reached inside intersect operator");
        }
        return includeSet;
    }

    public static <V> boolean add(V object, Collection<V> excludeSet, AtomicLong used, long maxSize) throws QueryEvaluationException {
        boolean add = excludeSet.add(object);
        if (add && used.incrementAndGet() > maxSize) {
            throw new QueryEvaluationException("Size limited reached inside query operator.");
        }
        return add;
    }
}

